/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IFabricatorSmeltingManager;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.FabricatorSmeltingRecipe;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorSmeltingRecipeManager
implements IFabricatorSmeltingManager {
    public static final Set<IFabricatorSmeltingRecipe> recipes = new HashSet<IFabricatorSmeltingRecipe>();

    public static IFabricatorSmeltingRecipe findMatchingSmelting(ItemStack resource) {
        if (resource == null) {
            return null;
        }
        for (IFabricatorSmeltingRecipe smelting : recipes) {
            if (!ItemStackUtil.isCraftingEquivalent(smelting.getResource(), resource)) continue;
            return smelting;
        }
        return null;
    }

    @Override
    public void addSmelting(ItemStack resource, FluidStack molten, int meltingPoint) {
        if (resource == null || molten == null) {
            return;
        }
        this.addRecipe(new FabricatorSmeltingRecipe(resource, molten, meltingPoint));
    }

    @Override
    public boolean addRecipe(IFabricatorSmeltingRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(IFabricatorSmeltingRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Collection<IFabricatorSmeltingRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }
}

