/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.utils;

import java.util.Random;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public final class VectUtil {
	public static BlockPos getRandomPositionInArea(Random random, Vec3i area) {
		int x = random.nextInt(area.func_177958_n());
		int y = random.nextInt(area.func_177956_o());
		int z = random.nextInt(area.func_177952_p());
		return new BlockPos(x, y, z);
	}

	public static BlockPos add(Vec3i... vects) {
		int x = 0;
		int y = 0;
		int z = 0;
		for (Vec3i vect : vects) {
			x += vect.func_177958_n();
			y += vect.func_177956_o();
			z += vect.func_177952_p();
		}
		return new BlockPos(x, y, z);
	}

	public static BlockPos scale(Vec3i vect, float factor) {
		return new BlockPos(vect.func_177958_n() * factor, vect.func_177956_o() * factor, vect.func_177952_p() * factor);
	}

	public static EnumFacing direction(Vec3i a, Vec3i b) {
		int x = Math.abs(a.func_177958_n() - b.func_177958_n());
		int y = Math.abs(a.func_177956_o() - b.func_177956_o());
		int z = Math.abs(a.func_177952_p() - b.func_177952_p());
		int max = Math.max(x, Math.max(y, z));
		if (max == x) {
			return EnumFacing.EAST;
		} else if (max == z) {
			return EnumFacing.SOUTH;
		} else {
			return EnumFacing.UP;
		}
	}
}
