/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.storage;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

import forestry.api.storage.IBackpackDefinition;
import forestry.core.IPickupHandler;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.items.ItemBackpack;

public class PickupHandlerStorage implements IPickupHandler {

	@Override
	public boolean onItemPickup(EntityPlayer player, EntityItem entityitem) {

		ItemStack itemstack = entityitem.func_92059_d();
		if (itemstack == null || itemstack.field_77994_a <= 0) {
			return false;
		}

		// Do not pick up if a backpack is open
		if (player.field_71070_bA instanceof ContainerBackpack || player.field_71070_bA instanceof ContainerNaturalistBackpack) {
			return false;
		}

		// Make sure to top off manually placed itemstacks in player inventory first
		topOffPlayerInventory(player, itemstack);

		for (ItemStack pack : player.field_71071_by.field_70462_a) {

			if (pack == null || pack.field_77994_a <= 0) {
				continue;
			}

			if (itemstack.field_77994_a <= 0) {
				break;
			}

			if (!(pack.func_77973_b() instanceof ItemBackpack)) {
				continue;
			}

			ItemBackpack backpack = (ItemBackpack) pack.func_77973_b();
			IBackpackDefinition backpackDefinition = backpack.getDefinition();
			if (backpackDefinition.test(itemstack)) {
				ItemBackpack.tryStowing(player, pack, itemstack);
			}
		}

		return itemstack.field_77994_a == 0;
	}

	/**
	 * This tops off existing stacks in the player's inventory. That way you can keep f.e. a stack of dirt or cobblestone in your inventory which gets refreshed
	 * constantly by picked up items.
	 */
	private static void topOffPlayerInventory(EntityPlayer player, ItemStack itemstack) {

		// Add to player inventory first, if there is an incomplete stack in
		// there.
		for (int i = 0; i < player.field_71071_by.func_70302_i_(); i++) {
			ItemStack inventoryStack = player.field_71071_by.func_70301_a(i);
			// We only add to existing stacks.
			if (inventoryStack == null) {
				continue;
			}

			// Already full
			if (inventoryStack.field_77994_a >= inventoryStack.func_77976_d()) {
				continue;
			}

			if (inventoryStack.func_77969_a(itemstack) && ItemStack.func_77970_a(inventoryStack, itemstack)) {
				int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;

				// Enough space to add all
				if (space > itemstack.field_77994_a) {
					inventoryStack.field_77994_a += itemstack.field_77994_a;
					itemstack.field_77994_a = 0;
					break;
					// Only part can be added
				} else {
					inventoryStack.field_77994_a = inventoryStack.func_77976_d();
					itemstack.field_77994_a -= space;
				}
			}
		}

	}

}
