/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.farming.blocks;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.core.blocks.BlockStructure;
import forestry.core.blocks.propertys.UnlistedBlockAccess;
import forestry.core.blocks.propertys.UnlistedBlockPos;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.models.EnumFarmBlockTexture;
import forestry.farming.tiles.TileFarm;
import forestry.farming.tiles.TileFarmControl;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmHatch;
import forestry.farming.tiles.TileFarmPlain;
import forestry.farming.tiles.TileFarmValve;

public class BlockFarm extends BlockStructure {

	public static final PropertyEnum<EnumFarmBlockType> META = PropertyEnum.func_177709_a("meta", EnumFarmBlockType.class);
	
	public BlockFarm() {
		super(Material.field_151576_e);
		func_149711_c(1.0f);
		setHarvestLevel("pickaxe", 0);
		func_180632_j(field_176227_L.func_177621_b().func_177226_a(META, EnumFarmBlockType.PLAIN));
		func_149647_a(Tabs.tabAgriculture);
	}
	

	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(META, EnumFarmBlockType.VALUES[meta]);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(META).ordinal();
	}

	@Override
	public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
		return ((IExtendedBlockState) super.getExtendedState(state, world, pos)).withProperty(UnlistedBlockPos.POS, pos)
				.withProperty(UnlistedBlockAccess.BLOCKACCESS, world);
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new ExtendedBlockState(this, new IProperty[]{META},
				new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
		for (int i = 0; i < 6; i++) {
			if (i == 1) {
				continue;
			}

			for (EnumFarmBlockTexture block : EnumFarmBlockTexture.values()) {
				ItemStack stack = new ItemStack(item, 1, i);
				NBTTagCompound compound = new NBTTagCompound();
				block.saveToCompound(compound);
				stack.func_77982_d(compound);
				list.add(stack);
			}
		}
	}

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
		List<ItemStack> drops = getDrops(world, pos, world.func_180495_p(pos), 0);
		if (drops.isEmpty()) {
			return super.getPickBlock(state, target, world, pos, player);
		}
		return drops.get(0);
	}
	
	@Override
	public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
		super.func_180633_a(world, pos, state, placer, stack);
		
		if (!stack.func_77942_o()) {
			return;
		}

		TileFarm tile = (TileFarm) world.func_175625_s(pos);
		tile.setFarmBlockTexture(EnumFarmBlockTexture.getFromCompound(stack.func_77978_p()));
	}

	@Override
	public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
		if (!world.field_72995_K && canHarvestBlock(world, pos, player)) {
			List<ItemStack> drops = getDrops(world, pos, world.func_180495_p(pos), 0);
			for (ItemStack drop : drops) {
				ItemStackUtil.dropItemStackAsEntity(drop, world, pos);
			}
		}
		return world.func_175698_g(pos);
	}
	
	@Override
	public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		ArrayList<ItemStack> drops = new ArrayList<>();
		int meta = func_176201_c(state);
		TileEntity tile = world.func_175625_s(pos);
		if (tile instanceof TileFarm) {
			TileFarm farm = (TileFarm) tile;

			ItemStack stack = new ItemStack(this, 1, meta != 1 ? meta : 0);
			NBTTagCompound compound = new NBTTagCompound();
			farm.getFarmBlockTexture().saveToCompound(compound);
			stack.func_77982_d(compound);
			drops.add(stack);
		}
		return drops;
	}

	@Override
	public TileEntity func_149915_a(World world, int meta) {
		switch (meta) {
			case 2:
				return new TileFarmGearbox();
			case 3:
				return new TileFarmHatch();
			case 4:
				return new TileFarmValve();
			case 5:
				return new TileFarmControl();
			default:
				return new TileFarmPlain();
		}
	}

	/* MODELS */
	@Override
	@SideOnly(Side.CLIENT)
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.CUTOUT;
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for(int i = 0;i < 6;i++){
			if(i == 1){
				continue;
			}
			ModelLoader.setCustomModelResourceLocation(item, i, new ModelResourceLocation("forestry:ffarm", "inventory"));
		}
	}

	@Override
	public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
		IBlockState blockState = world.func_180495_p(pos);
		return blockState.func_177229_b(META) == EnumFarmBlockType.CONTROL;
	}

	public ItemStack get(EnumFarmBlockType type, int amount) {
		return new ItemStack(this, amount, type.ordinal());
	}
}
