/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.items;

import java.util.List;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.apiculture.entities.EntityMinecartApiary;
import forestry.apiculture.entities.EntityMinecartBeeHousingBase;
import forestry.apiculture.entities.EntityMinecartBeehouse;

public class ItemMinecartBeehouse extends ItemMinecart implements IItemModelRegister {
	private final String[] definition = new String[]{"cart.beehouse", "cart.apiary"};
	
	private static final IBehaviorDispenseItem dispenserMinecartBehavior = new IBehaviorDispenseItem() {
		@Override
		public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
			return stack;
		}
	};

	public ItemMinecartBeehouse() {
		super(null);
		func_77656_e(0);
		func_77627_a(true);
		BlockDispenser.field_149943_a.func_82595_a(this, dispenserMinecartBehavior);
	}

	@Override
	public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		if (!BlockRailBase.func_176563_d(worldIn.func_180495_p(pos))) {
			return EnumActionResult.PASS;
		}

		if (!worldIn.field_72995_K) {
			EntityMinecartBeeHousingBase entityMinecart;
			if (stack.func_77952_i() == 0) {
				entityMinecart = new EntityMinecartBeehouse(worldIn, pos.func_177958_n() + 0.5F, pos.func_177956_o() + 0.5F, pos.func_177952_p() + 0.5F);
			} else {
				entityMinecart = new EntityMinecartApiary(worldIn, pos.func_177958_n() + 0.5F, pos.func_177956_o() + 0.5F, pos.func_177952_p() + 0.5F);
			}
			entityMinecart.setOwner(playerIn.func_146103_bH());

			if (stack.func_82837_s()) {
				entityMinecart.func_96094_a(stack.func_82833_r());
			}

			worldIn.func_72838_d(entityMinecart);
		}

		--stack.field_77994_a;
		return EnumActionResult.SUCCESS;
	}

	@Override
	public String func_77667_c(ItemStack stack) {
		if (stack.func_77952_i() >= definition.length || stack.func_77952_i() < 0) {
			return "item.forestry.unknown";
		} else {
			return "item.for." + definition[stack.func_77952_i()];
		}
	}

	/* MODELS */
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (int i = 0; i < definition.length; i++) {
			manager.registerItemModel(item, i, definition[i]);
		}
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
		for (int i = 0; i < definition.length; i++) {
			itemList.add(new ItemStack(this, 1, i));
		}
	}

	public ItemStack getBeeHouseMinecart() {
		return new ItemStack(this, 1, 0);
	}

	public ItemStack getApiaryMinecart() {
		return new ItemStack(this, 1, 1);
	}
}
