/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.gui.slots;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.stats.AchievementList;

import net.minecraftforge.fml.common.FMLCommonHandler;

import forestry.factory.tiles.ICrafterWorktable;

public class SlotCrafter extends Slot {

	/** The craft matrix inventory linked to this result slot. */
	private final IInventory craftMatrix;
	private final ICrafterWorktable crafter;
	
	/** The player that is using the GUI where this slot resides. */
	private final EntityPlayer thePlayer;
	/** The number of items that have been crafted so far. Gets passed to ItemStack.onCrafting before being reset. */
	private int amountCrafted;

	public SlotCrafter(EntityPlayer player, IInventory craftMatrix, ICrafterWorktable crafter, int slot, int xPos, int yPos) {
		super(craftMatrix, slot, xPos, yPos);
		this.craftMatrix = craftMatrix;
		this.crafter = crafter;
		this.thePlayer = player;
	}
	
	/**
	 * Check if the stack is a valid item for this slot. Always true beside for the armor slots.
	 */
	@Override
	public boolean func_75214_a(ItemStack stack) {
		return false;
	}

	/**
	 * the itemStack passed in is the output - ie, iron ingots, and pickaxes, not ore and wood. Typically increases an
	 * internal count then calls onCrafting(item).
	 */
	@Override
	protected void func_75210_a(ItemStack stack, int amount) {
		this.amountCrafted += amount;
		this.func_75208_c(stack);
	}

	/**
	 * the itemStack passed in is the output - ie, iron ingots, and pickaxes, not ore and wood.
	 * Copied from {@link SlotCrafting#onCrafting(ItemStack)}
	 */
	@Override
	protected void func_75208_c(ItemStack stack) {
		if (this.amountCrafted > 0) {
			stack.func_77980_a(this.thePlayer.field_70170_p, this.thePlayer, this.amountCrafted);
		}

		this.amountCrafted = 0;

		if (stack.func_77973_b() == Item.func_150898_a(Blocks.field_150462_ai)) {
			this.thePlayer.func_71029_a(AchievementList.field_187984_h);
		}

		if (stack.func_77973_b() instanceof ItemPickaxe) {
			this.thePlayer.func_71029_a(AchievementList.field_187985_i);
		}

		if (stack.func_77973_b() == Item.func_150898_a(Blocks.field_150460_al)) {
			this.thePlayer.func_71029_a(AchievementList.field_187986_j);
		}

		if (stack.func_77973_b() instanceof ItemHoe) {
			this.thePlayer.func_71029_a(AchievementList.field_76013_l);
		}

		if (stack.func_77973_b() == Items.field_151025_P) {
			this.thePlayer.func_71029_a(AchievementList.field_187988_m);
		}

		if (stack.func_77973_b() == Items.field_151105_aU) {
			this.thePlayer.func_71029_a(AchievementList.field_76011_n);
		}

		if (stack.func_77973_b() instanceof ItemPickaxe && ((ItemPickaxe) stack.func_77973_b()).func_150913_i() != Item.ToolMaterial.WOOD) {
			this.thePlayer.func_71029_a(AchievementList.field_187989_o);
		}

		if (stack.func_77973_b() instanceof ItemSword) {
			this.thePlayer.func_71029_a(AchievementList.field_187991_r);
		}

		if (stack.func_77973_b() == Item.func_150898_a(Blocks.field_150381_bn)) {
			this.thePlayer.func_71029_a(AchievementList.field_187972_E);
		}

		if (stack.func_77973_b() == Item.func_150898_a(Blocks.field_150342_X)) {
			this.thePlayer.func_71029_a(AchievementList.field_187974_G);
		}
	}

	@Override
	public ItemStack func_75209_a(int amount) {
		if (!this.func_75216_d()) {
			return null;
		}

		return this.func_75211_c();
	}

	@Override
	public boolean func_82869_a(EntityPlayer player) {
		return crafter.canTakeStack(getSlotIndex());
	}

	@Override
	public ItemStack func_75211_c() {
		return crafter.getResult();
	}

	@Override
	public boolean func_75216_d() {
		return func_75211_c() != null && crafter.canTakeStack(getSlotIndex());
	}

	@Override
	public void func_82870_a(EntityPlayer player, ItemStack itemStack) {
		if (!crafter.onCraftingStart(player)) {
			return;
		}

		FMLCommonHandler.instance().firePlayerCraftingEvent(player, itemStack, craftMatrix);
		this.func_75208_c(itemStack); // handles crafting achievements, maps, and statistics

		crafter.onCraftingComplete(player);
	}
}
