/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.IModelManager;
import forestry.api.core.IToolPipette;
import forestry.core.fluids.PipetteContents;
import forestry.core.items.ItemForestry;
import java.util.List;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPipette
extends ItemForestry
implements IToolPipette,
IFluidContainerItem {
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation[] models;

    public ItemPipette() {
        this.func_77625_d(1);
        this.func_77664_n();
    }

    @Override
    public boolean canPipette(ItemStack itemstack) {
        PipetteContents contained = PipetteContents.create(itemstack);
        return contained == null || !contained.isFull();
    }

    @Override
    public int fill(ItemStack itemstack, FluidStack liquid, boolean doFill) {
        int filled;
        PipetteContents contained = PipetteContents.create(itemstack);
        int limit = this.getCapacity(itemstack);
        if (contained == null) {
            filled = liquid.amount > limit ? limit : liquid.amount;
            contained = new PipetteContents(new FluidStack(liquid, filled));
            filled = liquid.amount;
        } else {
            if (contained.getContents().amount >= limit) {
                return 0;
            }
            if (!contained.getContents().isFluidEqual(liquid)) {
                return 0;
            }
            int space = limit - contained.getContents().amount;
            filled = liquid.amount > space ? space : liquid.amount;
            contained.getContents().amount += filled;
        }
        if (doFill) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            contained.writeToNBT(nbttagcompound);
            itemstack.func_77982_d(nbttagcompound);
            itemstack.func_77964_b(1);
        }
        return filled;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> list, boolean flag) {
        PipetteContents contained = PipetteContents.create(itemstack);
        if (contained != null) {
            contained.addTooltip(list);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        this.models = new ModelResourceLocation[2];
        this.models[0] = manager.getModelLocation("pipette.0");
        this.models[1] = manager.getModelLocation("pipette.1");
        manager.registerVariant(item, new ResourceLocation("forestry:pipette.0"));
        manager.registerVariant(item, new ResourceLocation("forestry:pipette.1"));
        manager.registerItemModel(item, new PipetteMeshDefinition());
    }

    @Override
    public FluidStack drain(ItemStack pipette, int maxDrain, boolean doDrain) {
        PipetteContents contained = PipetteContents.create(pipette);
        if (contained == null) {
            return null;
        }
        int drained = maxDrain;
        if (contained.getContents().amount < drained) {
            drained = contained.getContents().amount;
        }
        if (doDrain) {
            contained.getContents().amount -= drained;
            if (contained.getContents().amount <= 0) {
                pipette.func_77982_d(null);
                pipette.func_77964_b(0);
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                contained.writeToNBT(nbttagcompound);
                pipette.func_77982_d(nbttagcompound);
            }
        }
        return new FluidStack(contained.getContents(), drained);
    }

    public FluidStack getFluid(ItemStack container) {
        PipetteContents contained = PipetteContents.create(container);
        if (contained == null) {
            return null;
        }
        return contained.getContents();
    }

    @Override
    public int getCapacity(ItemStack pipette) {
        return 1000;
    }

    public class PipetteMeshDefinition
    implements ItemMeshDefinition {
        public ModelResourceLocation func_178113_a(ItemStack stack) {
            if (stack.func_77952_i() <= 0) {
                return ItemPipette.this.models[0];
            }
            return ItemPipette.this.models[1];
        }
    }
}

