/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderRandom
extends FruitProviderNone {
    @Nonnull
    private final Map<ItemStack, Float> products = new HashMap<ItemStack, Float>();
    private int colour = 0xFFFFFF;

    public FruitProviderRandom(String unlocalizedDescription, IFruitFamily family, ItemStack product, float modifier) {
        super(unlocalizedDescription, family);
        this.products.put(product, Float.valueOf(modifier));
    }

    public FruitProviderRandom setColour(Color colour) {
        this.colour = colour.getRGB();
        return this;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        return this.colour;
    }

    @Override
    public int getDecorativeColor() {
        return this.colour;
    }

    @Override
    @Nonnull
    public List<ItemStack> getFruits(ITreeGenome genome, World world, BlockPos pos, int ripeningTime) {
        ArrayList<ItemStack> product = new ArrayList<ItemStack>();
        float modeYieldMod = TreeManager.treeRoot.getTreekeepingMode(world).getYieldModifier(genome, 1.0f);
        for (Map.Entry<ItemStack, Float> entry : this.products.entrySet()) {
            if (!(world.field_73012_v.nextFloat() <= genome.getYield() * modeYieldMod * entry.getValue().floatValue())) continue;
            product.add(entry.getKey().func_77946_l());
        }
        return product;
    }

    @Override
    @Nonnull
    public Map<ItemStack, Float> getProducts() {
        return Collections.unmodifiableMap(this.products);
    }

    @Override
    public boolean isFruitLeaf(ITreeGenome genome, World world, BlockPos pos) {
        return true;
    }
}

