/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui.widgets;

import forestry.api.core.EnumCamouflageType;
import forestry.api.core.ICamouflageHandler;
import forestry.api.greenhouse.GreenhouseManager;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Translator;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetCamouflageSlot
extends Widget {
    private final ICamouflageHandler camouflageHandler;
    private final EnumCamouflageType type;
    protected final ToolTip toolTip = new ToolTip(250){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void refresh() {
            WidgetCamouflageSlot.this.toolTip.clear();
            String typeName = WidgetCamouflageSlot.this.type.name().toLowerCase(Locale.ENGLISH);
            if (WidgetCamouflageSlot.this.camouflageHandler instanceof IMultiblockController) {
                WidgetCamouflageSlot.this.toolTip.add(Translator.translateToLocal("for.gui.empty.slot.camouflage.multiblock." + typeName) + ": ");
            } else {
                WidgetCamouflageSlot.this.toolTip.add(Translator.translateToLocal("for.gui.empty.slot.camouflage") + ": ");
            }
            ItemStack camouflageBlock = WidgetCamouflageSlot.this.camouflageHandler.getCamouflageBlock(WidgetCamouflageSlot.this.type);
            if (WidgetCamouflageSlot.this.camouflageHandler == null || camouflageBlock == null) {
                WidgetCamouflageSlot.this.toolTip.add(TextFormatting.ITALIC.toString() + Translator.translateToLocal("for.gui.empty"));
            } else {
                Minecraft minecraft = Proxies.common.getClientInstance();
                WidgetCamouflageSlot.this.toolTip.add(TextFormatting.ITALIC.toString() + camouflageBlock.func_82840_a((EntityPlayer)minecraft.field_71439_g, minecraft.field_71474_y.field_82882_x));
            }
        }
    };

    public WidgetCamouflageSlot(WidgetManager manager, int xPos, int yPos, ICamouflageHandler camouflageHandler, EnumCamouflageType type) {
        super(manager, xPos, yPos);
        this.camouflageHandler = camouflageHandler;
        this.type = type;
    }

    @Override
    public void draw(int startX, int startY) {
        if (this.camouflageHandler != null && this.camouflageHandler.getCamouflageBlock(this.type) != null) {
            Proxies.render.bindTexture(TextureMap.field_110575_b);
            RenderItem renderItem = Proxies.common.getClientInstance().func_175599_af();
            renderItem.func_175042_a(this.camouflageHandler.getCamouflageBlock(this.type), startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        super.handleMouseClick(mouseX, mouseY, mouseButton);
        if (this.camouflageHandler == null) {
            return;
        }
        if (GuiScreen.func_146272_n()) {
            this.camouflageHandler.setCamouflageBlock(this.type, this.camouflageHandler.getDefaultCamouflageBlock(this.type));
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (stack != null && Block.func_149634_a((Item)stack.func_77973_b()) != null) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (!GreenhouseManager.greenhouseAccess.isOnCamouflageBlockBlackList(this.type, stack)) {
                    IBlockState stateFromMeta = block.func_176203_a(stack.func_77952_i());
                    if (this.type == EnumCamouflageType.DEFAULT && block.func_149662_c(stateFromMeta) && !block.hasTileEntity(stateFromMeta) && block.isNormalCube(stateFromMeta, (IBlockAccess)player.field_70170_p, this.camouflageHandler.getCoordinates())) {
                        this.camouflageHandler.setCamouflageBlock(this.type, stack);
                    } else if (this.type == EnumCamouflageType.GLASS && GreenhouseManager.greenhouseAccess.isGreenhouseGlass(stack)) {
                        this.camouflageHandler.setCamouflageBlock(this.type, stack);
                    }
                }
            }
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            return this.toolTip;
        }
        return null;
    }
}

