/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IToolScoop;
import forestry.api.core.Tabs;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.arboriculture.LeafDecayHelper;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.blocks.IColoredBlock;
import forestry.core.blocks.propertys.UnlistedBlockAccess;
import forestry.core.blocks.propertys.UnlistedBlockPos;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockForestryLeaves
extends BlockLeaves
implements ITileEntityProvider,
IGrowable,
IItemModelRegister,
IColoredBlock {
    private final ThreadLocal<List<ItemStack>> drops = new ThreadLocal();

    public BlockForestryLeaves() {
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{field_176237_a, field_176236_b}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileLeaves();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack held;
        TileLeaves leafTile = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (leafTile == null) {
            return;
        }
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184607_cu());
        float saplingModifier = 1.0f;
        if (!world.field_72995_K && (held = player.field_71071_by.func_70448_g()) != null && held.func_77973_b() instanceof IToolGrafter) {
            saplingModifier = ((IToolGrafter)held.func_77973_b()).getSaplingModifier(held, world, player, pos);
            held.func_77972_a(1, (EntityLivingBase)player);
            if (held.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)held, (EnumHand)EnumHand.MAIN_HAND);
                player.func_184611_a(EnumHand.MAIN_HAND, null);
            }
        }
        GameProfile playerProfile = player.func_146103_bH();
        List<ItemStack> leafDrops = BlockForestryLeaves.getLeafDrop((IBlockAccess)world, playerProfile, pos, saplingModifier, fortune);
        this.drops.set(leafDrops);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List<ItemStack> ret = this.drops.get();
        this.drops.remove();
        if (ret == null) {
            ret = BlockForestryLeaves.getLeafDrop(world, null, pos, 1.0f, fortune);
        }
        return ret;
    }

    private static List<ItemStack> getLeafDrop(IBlockAccess world, @Nullable GameProfile playerProfile, BlockPos pos, float saplingModifier, int fortune) {
        ITree[] saplings;
        ArrayList<ItemStack> prod = new ArrayList<ItemStack>();
        TileLeaves tile = TileUtil.getTile(world, pos, TileLeaves.class);
        if (tile == null) {
            return prod;
        }
        ITree tree = tile.getTree();
        if (tree == null) {
            return prod;
        }
        for (ITree sapling : saplings = tree.getSaplings((World)world, playerProfile, pos, saplingModifier)) {
            if (sapling == null) continue;
            prod.add(TreeManager.treeRoot.getMemberStack(sapling, EnumGermlingType.SAPLING));
        }
        if (tile.hasFruit()) {
            prod.addAll(tree.produceStacks((World)world, pos, tile.getRipeningTime()));
        }
        return prod;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileLeaves leaves = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (leaves == null) {
            return null;
        }
        ITree tree = leaves.getTree();
        if (tree == null) {
            return null;
        }
        String speciesUid = tree.getGenome().getPrimary().getUID();
        return PluginArboriculture.blocks.getDecorativeLeaves(speciesUid);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        TileLeaves leaves = TileUtil.getTile(world, pos, TileLeaves.class);
        if (leaves == null) {
            return null;
        }
        ITree tree = leaves.getTree();
        if (tree == null) {
            return null;
        }
        String speciesUid = tree.getGenome().getPrimary().getUID();
        return Collections.singletonList(PluginArboriculture.blocks.getDecorativeLeaves(speciesUid));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        TileLeaves tileLeaves = TileUtil.getTile((IBlockAccess)worldIn, pos, TileLeaves.class);
        if (tileLeaves != null && TreeDefinition.Willow.getUID().equals(tileLeaves.getSpeciesUID())) {
            return null;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        entityIn.field_70159_w *= 0.4;
        entityIn.field_70179_y *= 0.4;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        LeafDecayHelper.leafDecay(this, world, pos);
        TileLeaves tileLeaves = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (tileLeaves != null && !tileLeaves.func_145837_r() && (double)rand.nextFloat() <= 0.1) {
            tileLeaves.onBlockTick(world, pos, state, rand);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return !Proxies.render.fancyGraphicsEnabled();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Proxies.render.fancyGraphicsEnabled() || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) && BlockUtil.shouldSideBeRendered(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:leaves", "inventory"));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return 20;
        }
        if (face != EnumFacing.UP) {
            return 10;
        }
        return 5;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IButterfly caterpillar;
        TileEntity tile = worldIn.func_175625_s(pos);
        IButterfly iButterfly = caterpillar = tile instanceof TileLeaves ? ((TileLeaves)tile).getCaterpillar() : null;
        if (heldItem != null && heldItem.func_77973_b() instanceof IToolScoop && caterpillar != null) {
            ItemStack butterfly = ButterflyManager.butterflyRoot.getMemberStack(caterpillar, EnumFlutterType.CATERPILLAR);
            ItemStackUtil.dropItemStackAsEntity(butterfly, worldIn, pos);
            ((TileLeaves)tile).setCaterpillar(null);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        TileLeaves leafTile = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (leafTile != null) {
            return leafTile.hasFruit() && leafTile.getRipeness() < 1.0f;
        }
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        TileLeaves leafTile = TileUtil.getTile((IBlockAccess)world, pos, TileLeaves.class);
        if (leafTile != null) {
            leafTile.addRipeness(0.5f);
        }
    }

    @Override
    public int colorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        TileLeaves leaves = TileUtil.getTile(worldIn, pos, TileLeaves.class);
        if (leaves == null) {
            return PluginArboriculture.proxy.getFoliageColorBasic();
        }
        if (tintIndex == 0) {
            EntityPlayer thePlayer = Proxies.common.getPlayer();
            return leaves.getFoliageColour(thePlayer);
        }
        return leaves.getFruitColour();
    }
}

