/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumPostage;
import forestry.api.mail.EnumTradeStationState;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.IStamps;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Translator;
import forestry.mail.EnumDeliveryState;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.MailAddress;
import forestry.mail.PluginMail;
import forestry.mail.ResponseNotMailable;
import forestry.mail.TradeStationInfo;
import forestry.mail.inventory.InventoryTradeStation;
import forestry.mail.items.EnumStampDefinition;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class TradeStation
extends WorldSavedData
implements ITradeStation,
IInventoryAdapter {
    public static final String SAVE_NAME = "TradePO_";
    public static final short SLOT_TRADEGOOD = 0;
    public static final short SLOT_TRADEGOOD_COUNT = 1;
    public static final short SLOT_EXCHANGE_1 = 1;
    public static final short SLOT_EXCHANGE_COUNT = 4;
    public static final short SLOT_LETTERS_1 = 5;
    public static final short SLOT_LETTERS_COUNT = 6;
    public static final short SLOT_STAMPS_1 = 11;
    public static final short SLOT_STAMPS_COUNT = 4;
    public static final short SLOT_RECEIVE_BUFFER = 15;
    public static final short SLOT_RECEIVE_BUFFER_COUNT = 15;
    public static final short SLOT_SEND_BUFFER = 30;
    public static final short SLOT_SEND_BUFFER_COUNT = 10;
    public static final int SLOT_SIZE = 40;
    private GameProfile owner;
    private IMailAddress address;
    private boolean isVirtual = false;
    private boolean isInvalid = false;
    private final InventoryAdapter inventory = new InventoryTradeStation();

    public TradeStation(GameProfile owner, IMailAddress address) {
        super(SAVE_NAME + address);
        if (!address.isTrader()) {
            throw new IllegalArgumentException("TradeStation address must be a trader");
        }
        this.owner = owner;
        this.address = address;
    }

    public TradeStation(String savename) {
        super(savename);
    }

    @Override
    public IMailAddress getAddress() {
        return this.address;
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("owner")) {
            this.owner = PlayerUtil.readGameProfileFromNBT(nbttagcompound.func_74775_l("owner"));
        }
        if (nbttagcompound.func_74764_b("address")) {
            this.address = new MailAddress(nbttagcompound.func_74775_l("address"));
        }
        this.isVirtual = nbttagcompound.func_74767_n("VRT");
        this.isInvalid = nbttagcompound.func_74767_n("IVL");
        this.inventory.readFromNBT(nbttagcompound);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbt;
        if (this.owner != null) {
            nbt = new NBTTagCompound();
            PlayerUtil.writeGameProfile(nbt, this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
        if (this.address != null) {
            nbt = new NBTTagCompound();
            this.address.writeToNBT(nbt);
            nbttagcompound.func_74782_a("address", (NBTBase)nbt);
        }
        nbttagcompound.func_74757_a("VRT", this.isVirtual);
        nbttagcompound.func_74757_a("IVL", this.isInvalid);
        this.inventory.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public boolean isValid() {
        return !this.isInvalid;
    }

    @Override
    public void invalidate() {
        this.isInvalid = true;
    }

    @Override
    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
        this.func_70296_d();
    }

    @Override
    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public TradeStationInfo getTradeInfo() {
        ItemStack[] condensedRequired = ItemStackUtil.condenseStacks(InventoryUtil.getStacks((IInventory)this.inventory, 1, 4));
        EnumTradeStationState state = EnumTradeStationState.OK;
        if (!this.isVirtual()) {
            if (!this.hasPaper(2)) {
                state = EnumTradeStationState.INSUFFICIENT_PAPER;
            }
            if (!this.canPayPostage(3)) {
                state = EnumTradeStationState.INSUFFICIENT_STAMPS;
            }
            if (this.countFillableOrders(1, this.inventory.func_70301_a(0)) <= 0) {
                state = EnumTradeStationState.INSUFFICIENT_TRADE_GOOD;
            }
        }
        return new TradeStationInfo(this.address, this.owner, this.inventory.func_70301_a(0), condensedRequired, state);
    }

    @Override
    public IPostalState handleLetter(World world, IMailAddress recipient, ItemStack letterstack, boolean doLodge) {
        boolean sendOwnerNotice = doLodge && this.owner != null;
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        if (!this.isVirtual() && !this.hasPaper(sendOwnerNotice ? 2 : 1)) {
            return EnumTradeStationState.INSUFFICIENT_PAPER;
        }
        int ordersToFillCount = ItemStackUtil.containsSets(InventoryUtil.getStacks((IInventory)this.inventory, 1, 4), letter.getAttachments());
        if (ordersToFillCount <= 0) {
            return EnumTradeStationState.INSUFFICIENT_OFFER;
        }
        if (!this.isVirtual()) {
            int storable;
            int fillable = this.countFillableOrders(ordersToFillCount, this.inventory.func_70301_a(0));
            if (fillable <= 0) {
                return EnumTradeStationState.INSUFFICIENT_TRADE_GOOD;
            }
            if (fillable < ordersToFillCount) {
                ordersToFillCount = fillable;
            }
            if ((storable = this.countStorablePayment(ordersToFillCount, InventoryUtil.getStacks((IInventory)this.inventory, 1, 4))) <= 0) {
                return EnumTradeStationState.INSUFFICIENT_BUFFER;
            }
            if (storable < ordersToFillCount) {
                ordersToFillCount = storable;
            }
        }
        Letter mail = new Letter(this.address, letter.getSender());
        mail.setText(Translator.translateToLocal("for.gui.mail.order.attached"));
        for (int i = 0; i < ordersToFillCount; ++i) {
            mail.addAttachment(this.inventory.func_70301_a(0).func_77946_l());
        }
        mail.addAttachments(this.getSurplusAttachments(ordersToFillCount, letter.getAttachments()));
        int requiredPostage = mail.requiredPostage();
        if (!this.isVirtual() && !this.canPayPostage(requiredPostage + (sendOwnerNotice ? 1 : 0))) {
            return EnumTradeStationState.INSUFFICIENT_STAMPS;
        }
        int[] stampCount = this.getPostage(requiredPostage, this.isVirtual());
        for (int i = 0; i < stampCount.length; ++i) {
            int count = stampCount[i];
            if (count <= 0) continue;
            EnumPostage postage = EnumPostage.values()[i];
            EnumStampDefinition stampDefinition = EnumStampDefinition.getFromPostage(postage);
            mail.addStamps(PluginMail.items.stamps.get(stampDefinition, count));
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        mail.writeToNBT(nbttagcompound);
        ItemStack mailstack = LetterProperties.createStampedLetterStack(mail);
        mailstack.func_77982_d(nbttagcompound);
        IPostalState responseState = PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, mailstack, doLodge);
        if (!responseState.isOk()) {
            return new ResponseNotMailable(responseState);
        }
        for (int i = 0; i < ordersToFillCount; ++i) {
            for (ItemStack stack : InventoryUtil.getStacks((IInventory)this.inventory, 1, 4)) {
                if (stack == null) continue;
                InventoryUtil.tryAddStack((IInventory)this.inventory, stack.func_77946_l(), 15, 15, false);
            }
        }
        this.removePaper();
        this.removeStamps(stampCount);
        this.removeTradegood(ordersToFillCount);
        if (sendOwnerNotice) {
            String orderFilledMessage;
            nbttagcompound = new NBTTagCompound();
            Letter confirm = new Letter(this.address, new MailAddress(this.owner));
            if (ordersToFillCount == 1) {
                orderFilledMessage = Translator.translateToLocal("for.gui.mail.order.filled.one");
            } else {
                orderFilledMessage = Translator.translateToLocal("for.gui.mail.order.filled.multiple");
                orderFilledMessage = orderFilledMessage.replace("%COUNT", Integer.toString(ordersToFillCount));
            }
            orderFilledMessage = orderFilledMessage.replace("%SENDER", letter.getSender().getName());
            confirm.setText(orderFilledMessage);
            confirm.addStamps(PluginMail.items.stamps.get(EnumStampDefinition.P_1, 1));
            confirm.writeToNBT(nbttagcompound);
            ItemStack confirmstack = LetterProperties.createStampedLetterStack(confirm);
            confirmstack.func_77982_d(nbttagcompound);
            PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, confirmstack, doLodge);
            this.removePaper();
            this.removeStamps(new int[]{0, 1});
        }
        this.func_70296_d();
        return EnumDeliveryState.OK;
    }

    private int countFillableOrders(int max, ItemStack tradegood) {
        if (tradegood == null) {
            return 0;
        }
        float orderCount = 0.0f;
        for (ItemStack stack : InventoryUtil.getStacks((IInventory)this.inventory, 30, 10)) {
            if (stack == null || !stack.func_77969_a(tradegood) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)tradegood) || !((orderCount += (float)stack.field_77994_a / (float)tradegood.field_77994_a) >= (float)max)) continue;
            return max;
        }
        return (int)Math.floor(orderCount);
    }

    public boolean canReceivePayment() {
        InventoryAdapter test = this.inventory.copy();
        ItemStack[] payment = InventoryUtil.getStacks((IInventory)this.inventory, 1, 4);
        return InventoryUtil.tryAddStacksCopy((IInventory)test, payment, 15, 15, true);
    }

    private int countStorablePayment(int max, ItemStack[] exchange) {
        InventoryAdapter test = this.inventory.copy();
        int count = 0;
        for (int i = 0; i < max && InventoryUtil.tryAddStacksCopy((IInventory)test, exchange, 15, 15, true); ++i) {
            ++count;
        }
        return count;
    }

    private void removeTradegood(int filled) {
        block0: for (int j = 0; j < filled; ++j) {
            int toRemove = this.inventory.func_70301_a((int)0).field_77994_a;
            for (int i = 30; i < 40; ++i) {
                ItemStack buffer = this.inventory.func_70301_a(i);
                if (buffer == null || !buffer.func_77969_a(this.inventory.func_70301_a(0)) || !ItemStack.func_77970_a((ItemStack)buffer, (ItemStack)this.inventory.func_70301_a(0))) continue;
                ItemStack decrease = this.inventory.func_70298_a(i, toRemove);
                if ((toRemove -= decrease.field_77994_a) <= 0) continue block0;
            }
        }
    }

    private boolean hasPaper(int amountRequired) {
        int amountFound = 0;
        for (ItemStack stack : InventoryUtil.getStacks((IInventory)this.inventory, 5, 6)) {
            if (stack != null) {
                amountFound += stack.field_77994_a;
            }
            if (amountFound < amountRequired) continue;
            return true;
        }
        return false;
    }

    private void removePaper() {
        for (int i = 5; i < 11; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != Items.field_151121_aF || stack.field_77994_a <= 0) continue;
            this.inventory.func_70298_a(i, 1);
            break;
        }
    }

    private boolean canPayPostage(int postage) {
        int posted = 0;
        for (ItemStack stamp : InventoryUtil.getStacks((IInventory)this.inventory, 11, 4)) {
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps) || (posted += ((IStamps)stamp.func_77973_b()).getPostage(stamp).getValue() * stamp.field_77994_a) < postage) continue;
            return true;
        }
        return false;
    }

    private int[] getPostage(int postageRequired, boolean virtual) {
        int num;
        EnumPostage postValue;
        int i;
        int[] stamps = new int[EnumPostage.values().length];
        int postageRemaining = postageRequired;
        for (i = EnumPostage.values().length - 1; i > 0 && postageRemaining > 0; --i) {
            postValue = EnumPostage.values()[i];
            if (postValue.getValue() > postageRemaining) continue;
            num = virtual ? 99 : this.getNumStamps(postValue);
            int max = (int)Math.floor(postageRemaining / postValue.getValue());
            if (max < num) {
                num = max;
            }
            stamps[i] = num;
            postageRemaining -= num * postValue.getValue();
        }
        if (postageRemaining > 0) {
            for (i = 0; i < EnumPostage.values().length; ++i) {
                postValue = EnumPostage.values()[i];
                if (postValue.getValue() < postageRequired) continue;
                stamps = new int[EnumPostage.values().length];
                int n = num = virtual ? 99 : this.getNumStamps(postValue);
                if (num <= 0) continue;
                stamps[i] = 1;
                return stamps;
            }
        }
        return stamps;
    }

    private int getNumStamps(EnumPostage postage) {
        int count = 0;
        for (ItemStack stamp : InventoryUtil.getStacks((IInventory)this.inventory, 11, 4)) {
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps) || ((IStamps)stamp.func_77973_b()).getPostage(stamp) != postage) continue;
            count += stamp.field_77994_a;
        }
        return count;
    }

    private void removeStamps(int[] stampCount) {
        for (int i = 1; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            for (int j = 11; j < 15; ++j) {
                ItemStack stamp;
                if (stampCount[i] <= 0 || (stamp = this.inventory.func_70301_a(j)) == null || !(stamp.func_77973_b() instanceof IStamps) || ((IStamps)stamp.func_77973_b()).getPostage(stamp) != EnumPostage.values()[i]) continue;
                ItemStack decrease = this.inventory.func_70298_a(j, stampCount[i]);
                int n = i;
                stampCount[n] = stampCount[n] - decrease.field_77994_a;
            }
        }
    }

    private ItemStack[] getSurplusAttachments(int filled, ItemStack[] attachments) {
        int i;
        ArrayList<ItemStack> surplus = new ArrayList<ItemStack>();
        ItemStack[] pool = new ItemStack[attachments.length];
        for (i = 0; i < attachments.length; ++i) {
            if (attachments[i] == null) continue;
            pool[i] = attachments[i].func_77946_l();
        }
        for (i = 0; i < filled; ++i) {
            ItemStack[] condensedRequired;
            ItemStack[] required = InventoryUtil.getStacks((IInventory)this.inventory, 1, 4);
            for (ItemStack req : condensedRequired = ItemStackUtil.condenseStacks(required)) {
                for (int j = 0; j < pool.length; ++j) {
                    ItemStack pol = pool[j];
                    if (pol == null || !pol.func_77969_a(req)) continue;
                    if (req.field_77994_a >= pol.field_77994_a) {
                        req.field_77994_a -= pol.field_77994_a;
                        pool[j] = null;
                        continue;
                    }
                    pol.field_77994_a -= req.field_77994_a;
                    req.field_77994_a = 0;
                }
            }
        }
        for (ItemStack stack : pool) {
            if (stack == null) continue;
            surplus.add(stack);
        }
        return surplus.toArray(new ItemStack[surplus.size()]);
    }

    public void func_70296_d() {
        super.func_76185_a();
        this.inventory.func_70296_d();
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.func_70296_d();
        this.inventory.func_70299_a(slot, itemStack);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.inventory.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return this.inventory.func_94041_b(i, itemStack);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.inventory.func_180463_a(side);
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return this.inventory.func_180462_a(slot, itemStack, side);
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing side) {
        return this.inventory.func_180461_b(slot, itemStack, side);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.inventory.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.inventory.isLocked(slotIndex);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

