/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.bottler;

import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.render.ForestryResource;
import java.util.Collection;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class BottlerRecipeCategory
extends ForestryRecipeCategory {
    private static final int emptySlot = 0;
    private static final int outputSlot = 1;
    private static final int inputTank = 2;
    private static final ResourceLocation guiTexture = new ForestryResource("textures/gui/bottler.png");
    @Nonnull
    private final IDrawableAnimated arrow;
    @Nonnull
    private final IDrawable tankOverlay;

    public BottlerRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 52, 16, 81, 60), "tile.for.bottler.name");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(guiTexture, 176, 74, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(guiTexture, 176, 0, 16, 58);
    }

    @Nonnull
    public String getUid() {
        return "forestry.bottler";
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 28, 23);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 63, 2);
        guiItemStacks.init(1, false, 63, 38);
        guiFluidStacks.init(2, true, 1, 1, 16, 58, 10000, false, this.tankOverlay);
        guiItemStacks.setFromRecipe(0, recipeWrapper.getInputs());
        guiItemStacks.setFromRecipe(1, recipeWrapper.getOutputs());
        guiFluidStacks.set(2, (Collection)recipeWrapper.getFluidInputs());
    }
}

