/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAllele;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.access.IOwnable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.PlayerUtil;
import forestry.greenhouse.multiblock.GreenhouseController;
import forestry.lepidopterology.genetics.Butterfly;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileCocoon
extends TileEntity
implements IStreamable,
IOwnable,
IButterflyCocoon {
    private int age;
    private int maturationTime;
    private IButterfly caterpillar;
    private GameProfile owner;
    private BlockPos nursery;
    private boolean isSolid;

    public TileCocoon() {
    }

    public TileCocoon(boolean isSolid) {
        this.isSolid = isSolid;
        if (isSolid) {
            this.age = 2;
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("Caterpillar")) {
            this.caterpillar = new Butterfly(nbttagcompound.func_74775_l("Caterpillar"));
        }
        if (nbttagcompound.func_74764_b("owner")) {
            this.owner = PlayerUtil.readGameProfileFromNBT(nbttagcompound.func_74775_l("owner"));
        }
        if (nbttagcompound.func_74764_b("nursery")) {
            NBTTagCompound nbt = nbttagcompound.func_74775_l("nursery");
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            this.nursery = new BlockPos(x, y, z);
        }
        this.age = nbttagcompound.func_74762_e("Age");
        this.maturationTime = nbttagcompound.func_74762_e("CATMAT");
        this.isSolid = nbttagcompound.func_74767_n("isSolid");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        if (this.caterpillar != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.caterpillar.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("Caterpillar", (NBTBase)subcompound);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            PlayerUtil.writeGameProfile(nbt, this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
        if (this.nursery != null) {
            BlockPos pos = this.nursery;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("x", pos.func_177958_n());
            nbt.func_74768_a("y", pos.func_177956_o());
            nbt.func_74768_a("z", pos.func_177952_p());
            nbttagcompound.func_74782_a("nursery", (NBTBase)nbt);
        }
        nbttagcompound.func_74768_a("Age", this.age);
        nbttagcompound.func_74768_a("CATMAT", this.maturationTime);
        nbttagcompound.func_74757_a("isSolid", this.isSolid);
        return nbttagcompound;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        String speciesUID = "";
        IButterfly caterpillar = this.getCaterpillar();
        if (caterpillar != null) {
            speciesUID = caterpillar.getIdent();
        }
        data.writeUTF(speciesUID);
        data.writeInt(this.age);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        String speciesUID = data.readUTF();
        IButterfly caterpillar = TileCocoon.getButterfly(speciesUID);
        this.setCaterpillar(caterpillar);
        this.age = data.readInt();
    }

    private static IButterfly getButterfly(String speciesUID) {
        IAllele[] butterflyTemplate = ButterflyManager.butterflyRoot.getTemplate(speciesUID);
        if (butterflyTemplate == null) {
            return null;
        }
        return ButterflyManager.butterflyRoot.templateAsIndividual(butterflyTemplate);
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return player != null && PlayerUtil.isSameGameProfile(player.func_146103_bH(), this.owner);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !Block.func_149680_a((Block)oldState.func_177230_c(), (Block)newSate.func_177230_c());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }

    public void onBlockTick() {
        ++this.maturationTime;
        IButterflyGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getLifespan() / (float)(caterpillarGenome.getFertility() * 2));
        if (this.maturationTime >= caterpillarMatureTime) {
            if (this.age < 2) {
                ++this.age;
                this.maturationTime = 0;
            } else if (this.caterpillar.canTakeFlight(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p())) {
                IGreenhouseComponent.ButterflyHatch hatch = GreenhouseController.getGreenhouseButterflyHatch(this.field_145850_b, this.field_174879_c);
                ItemStack[] cocoonDrops = hatch != null ? hatch.addCocoonLoot(this) : this.caterpillar.getCocoonDrop(this);
                for (ItemStack drop : cocoonDrops) {
                    ItemStackUtil.dropItemStackAsEntity(drop, this.field_145850_b, this.field_174879_c);
                }
                this.field_145850_b.func_175698_g(this.func_174877_v());
                TileCocoon.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.func_174877_v());
            }
        }
    }

    private static void attemptButterflySpawn(World world, IButterfly butterfly, BlockPos pos) {
        if (ButterflyManager.butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), pos.func_177958_n(), (float)pos.func_177956_o() + 0.1f, pos.func_177952_p()) != null) {
            Log.trace("A caterpillar '%s' hatched at %s/%s/%s.", butterfly.getDisplayName(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    @Override
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public IButterflyNursery getNursery() {
        TileEntity nursery = this.field_145850_b.func_175625_s(this.nursery);
        if (nursery instanceof IButterflyNursery) {
            return (IButterflyNursery)nursery;
        }
        return null;
    }

    @Override
    public void setNursery(IButterflyNursery nursery) {
        this.nursery = nursery.getCoordinates();
    }

    @Override
    public void setCaterpillar(IButterfly butterfly) {
        this.caterpillar = butterfly;
        this.sendNetworkUpdate();
    }

    private void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(new PacketTileStream(this), this.field_145850_b);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public ItemStack[] getCocoonDrops() {
        return this.caterpillar.getCocoonDrop(this);
    }

    @Override
    public boolean isSolid() {
        return this.isSolid;
    }
}

