/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models.baker;

import forestry.api.core.IModelBaker;
import forestry.api.core.IModelBakerModel;
import forestry.core.models.ModelManager;
import forestry.core.models.baker.ModelBakerFace;
import forestry.core.models.baker.ModelBakerModel;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class ModelBaker
implements IModelBaker {
    private static final float[] quadsUV = new float[]{0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f};
    private final List<ModelBakerFace> faces = new ArrayList<ModelBakerFace>();
    private final List<IBakedModel> bakedModels = new ArrayList<IBakedModel>();
    protected AxisAlignedBB renderBounds;
    protected ModelBakerModel currentModel;
    protected final FaceBakery faceBakery;
    protected final float[] defUVs;
    protected int colorIndex;

    public ModelBaker() {
        this.currentModel = new ModelBakerModel(ModelManager.getInstance().DEFAULT_BLOCK);
        this.faceBakery = new FaceBakery();
        this.defUVs = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        this.colorIndex = -1;
    }

    @Override
    public void setRenderBounds(@Nonnull AxisAlignedBB renderBounds) {
        if (renderBounds == null) {
            return;
        }
        this.renderBounds = renderBounds;
    }

    @Override
    public void setRenderBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.renderBounds = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    @Override
    public void addModel(@Nonnull AxisAlignedBB renderBounds, @Nonnull TextureAtlasSprite[] textures, int colorIndex) {
        this.setRenderBounds(renderBounds);
        this.setColorIndex(colorIndex);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addFace(facing, textures[facing.ordinal()]);
        }
        this.setRenderBounds(Block.field_185505_j);
    }

    @Override
    public void addModel(@Nonnull AxisAlignedBB renderBounds, @Nonnull TextureAtlasSprite texture, int colorIndex) {
        this.addModel(renderBounds, new TextureAtlasSprite[]{texture, texture, texture, texture, texture, texture}, colorIndex);
    }

    @Override
    public void addBlockModel(@Nonnull Block block, @Nonnull AxisAlignedBB renderBounds, @Nullable BlockPos pos, @Nonnull TextureAtlasSprite[] textures, int colorIndex) {
        this.setRenderBounds(renderBounds);
        this.setColorIndex(colorIndex);
        if (pos != null) {
            World world = Proxies.common.getRenderWorld();
            IBlockState blockState = world.func_180495_p(pos);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!block.func_176225_a(blockState, (IBlockAccess)world, pos, facing)) continue;
                this.addFace(facing, textures[facing.ordinal()]);
            }
        } else {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.addFace(facing, textures[facing.ordinal()]);
            }
        }
        this.setRenderBounds(Block.field_185505_j);
    }

    @Override
    public void addBlockModel(@Nonnull Block block, @Nonnull AxisAlignedBB renderBounds, @Nullable BlockPos pos, @Nonnull TextureAtlasSprite texture, int colorIndex) {
        this.addBlockModel(block, renderBounds, pos, new TextureAtlasSprite[]{texture, texture, texture, texture, texture, texture}, colorIndex);
    }

    @Override
    public void addBakedModel(@Nonnull IBakedModel model) {
        this.bakedModels.add(model);
    }

    protected static float[] getFaceUvs(EnumFacing face, Vector3f to_16, Vector3f from_16) {
        float from_a = 0.0f;
        float from_b = 0.0f;
        float to_a = 0.0f;
        float to_b = 0.0f;
        switch (face) {
            case UP: {
                from_a = from_16.x / 16.0f;
                from_b = from_16.z / 16.0f;
                to_a = to_16.x / 16.0f;
                to_b = to_16.z / 16.0f;
                break;
            }
            case DOWN: {
                from_a = from_16.x / 16.0f;
                from_b = from_16.z / 16.0f;
                to_a = to_16.x / 16.0f;
                to_b = to_16.z / 16.0f;
                break;
            }
            case SOUTH: {
                from_a = from_16.x / 16.0f;
                from_b = from_16.y / 16.0f;
                to_a = to_16.x / 16.0f;
                to_b = to_16.y / 16.0f;
                break;
            }
            case NORTH: {
                from_a = from_16.x / 16.0f;
                from_b = from_16.y / 16.0f;
                to_a = to_16.x / 16.0f;
                to_b = to_16.y / 16.0f;
                break;
            }
            case EAST: {
                from_a = from_16.y / 16.0f;
                from_b = from_16.z / 16.0f;
                to_a = to_16.y / 16.0f;
                to_b = to_16.z / 16.0f;
                break;
            }
            case WEST: {
                from_a = from_16.y / 16.0f;
                from_b = from_16.z / 16.0f;
                to_a = to_16.y / 16.0f;
                to_b = to_16.z / 16.0f;
                break;
            }
        }
        from_a = 1.0f - from_a;
        from_b = 1.0f - from_b;
        to_a = 1.0f - to_a;
        to_b = 1.0f - to_b;
        return new float[]{16.0f * (quadsUV[0] + quadsUV[2] * from_a + quadsUV[4] * from_b), 16.0f * (quadsUV[1] + quadsUV[3] * from_a + quadsUV[5] * from_b), 16.0f * (quadsUV[0] + quadsUV[2] * to_a + quadsUV[4] * from_b), 16.0f * (quadsUV[1] + quadsUV[3] * to_a + quadsUV[5] * from_b), 16.0f * (quadsUV[0] + quadsUV[2] * to_a + quadsUV[4] * to_b), 16.0f * (quadsUV[1] + quadsUV[3] * to_a + quadsUV[5] * to_b), 16.0f * (quadsUV[0] + quadsUV[2] * from_a + quadsUV[4] * to_b), 16.0f * (quadsUV[1] + quadsUV[3] * from_a + quadsUV[5] * to_b)};
    }

    @Override
    public void addFace(@Nonnull EnumFacing facing, @Nonnull TextureAtlasSprite sprite) {
        if (sprite == null) {
            return;
        }
        Vector3f to = new Vector3f((float)this.renderBounds.field_72340_a * 16.0f, (float)this.renderBounds.field_72338_b * 16.0f, (float)this.renderBounds.field_72339_c * 16.0f);
        Vector3f from = new Vector3f((float)this.renderBounds.field_72336_d * 16.0f, (float)this.renderBounds.field_72337_e * 16.0f, (float)this.renderBounds.field_72334_f * 16.0f);
        this.faces.add(new ModelBakerFace(facing, this.colorIndex, to, from, this.defUVs, sprite));
    }

    @Override
    public IModelBakerModel bakeModel(boolean flip) {
        ModelRotation mr = ModelRotation.X0_Y0;
        if (flip) {
            mr = ModelRotation.X0_Y180;
        }
        for (IBakedModel bakedModel : this.bakedModels) {
            this.currentModel.addModelQuads(bakedModel);
        }
        for (ModelBakerFace face : this.faces) {
            EnumFacing myFace = face.face;
            float[] uvs = ModelBaker.getFaceUvs(myFace, face.from, face.to);
            BlockFaceUV uv = new BlockFaceUV(uvs, 0);
            BlockPartFace bpf = new BlockPartFace(myFace, face.colorIndex, "", uv);
            BakedQuad bf = this.faceBakery.func_178414_a(face.to, face.from, bpf, face.spite, myFace, mr, null, true, true);
            this.currentModel.addQuad(myFace, bf);
        }
        return this.currentModel;
    }

    @Override
    public void setModelState(IModelState modelState) {
        this.currentModel.setModelState(modelState);
    }

    @Override
    public void setParticleSprite(TextureAtlasSprite particleSprite) {
        this.currentModel.setParticleSprite(particleSprite);
    }
}

