/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.ICrateRegistry;
import forestry.core.items.ItemCrated;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.OreDictUtil;
import forestry.storage.PluginStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class CrateRegistry
implements ICrateRegistry {
    private static void registerCrate(@Nonnull ItemStack stack, @Nullable String oreDictName) {
        String crateName;
        if (stack == null || stack.func_77973_b() == null) {
            Log.warning("Tried to make a crate without an item", new Object[0]);
            return;
        }
        if (oreDictName != null) {
            crateName = "crated." + oreDictName;
        } else {
            String itemName = ItemStackUtil.getStringForItemStack(stack).replace(':', '.');
            crateName = "crated." + itemName;
        }
        ItemCrated crate = new ItemCrated(stack, oreDictName);
        crate.func_77655_b(crateName);
        crate.setRegistryName(crateName);
        GameRegistry.register((IForgeRegistryEntry)crate);
        Proxies.common.registerItem(crate);
        PluginStorage.registerCrate(crate);
    }

    @Override
    public void registerCrate(@Nonnull String oreDictName) {
        ItemStack stack = OreDictUtil.getFirstSuitableOre(oreDictName);
        if (stack != null) {
            CrateRegistry.registerCrate(stack, oreDictName);
        }
    }

    @Override
    public void registerCrate(@Nonnull Block block) {
        CrateRegistry.registerCrate(new ItemStack(block), null);
    }

    @Override
    public void registerCrate(@Nonnull Item item) {
        CrateRegistry.registerCrate(new ItemStack(item), null);
    }

    @Override
    public void registerCrate(@Nonnull ItemStack stack) {
        CrateRegistry.registerCrate(stack, null);
    }
}

