/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.items;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IModelManager;
import forestry.core.config.Config;

public class ItemOverlay extends ItemForestry implements IColoredItem {

	public interface IOverlayInfo {
		String getUid();

		int getPrimaryColor();

		int getSecondaryColor();

		boolean isSecret();
	}

	protected final IOverlayInfo[] overlays;

	public ItemOverlay(CreativeTabs tab, IOverlayInfo[] overlays) {
		func_77656_e(0);
		func_77627_a(true);
		func_77637_a(tab);

		this.overlays = overlays;
	}

	@Override
	public boolean func_77645_m() {
		return false;
	}

	@Override
	public boolean isRepairable() {
		return false;
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
		for (int i = 0; i < overlays.length; i++) {
			if (Config.isDebug || !overlays[i].isSecret()) {
				itemList.add(new ItemStack(this, 1, i));
			}
		}
	}
	
	/* Models */
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (int i = 0; i < overlays.length; i++) {
			manager.registerItemModel(item, i);
		}
	}

	@Override
	public String func_77667_c(ItemStack stack) {
		if (stack.func_77952_i() < 0 || stack.func_77952_i() >= overlays.length) {
			return null;
		}

		return super.func_77667_c(stack) + "." + overlays[stack.func_77952_i()].getUid();
	}

	@Override
	public int getColorFromItemstack(ItemStack stack, int tintIndex) {
		int meta = stack.func_77960_j();
		if (meta < 0 || meta >= overlays.length) {
			return 0xffffff;
		}

		IOverlayInfo overlayInfo = overlays[meta];
		if (tintIndex == 0 || overlayInfo.getSecondaryColor() == 0) {
			return overlayInfo.getPrimaryColor();
		} else {
			return overlayInfo.getSecondaryColor();
		}
	}
}
