package forestry.core.utils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class VillagerTradeLists {
	/**
	 * Copy of {@link net.minecraft.entity.passive.EntityVillager.ItemAndEmeraldToItem}
	 * that takes ItemStacks as parameters and has emerald price info
	 */
	public static class GiveItemForItemAndEmerald implements EntityVillager.ITradeList {
		@Nonnull
		public ItemStack buyingItemStack;
		@Nullable
		public EntityVillager.PriceInfo buyingPriceInfo;
		@Nullable
		public EntityVillager.PriceInfo emeraldPriceInfo;
		@Nonnull
		public ItemStack sellingItemstack;
		@Nullable
		public EntityVillager.PriceInfo sellingPriceInfo;

		public GiveItemForItemAndEmerald(
				@Nonnull ItemStack buyingItemStack,
				@Nullable EntityVillager.PriceInfo buyingPriceInfo,
				@Nullable EntityVillager.PriceInfo emeraldPriceInfo,
				@Nonnull ItemStack sellingItemstack,
				@Nullable EntityVillager.PriceInfo sellingPriceInfo) {
			this.buyingItemStack = buyingItemStack;
			this.buyingPriceInfo = buyingPriceInfo;
			this.emeraldPriceInfo = emeraldPriceInfo;
			this.sellingItemstack = sellingItemstack;
			this.sellingPriceInfo = sellingPriceInfo;
		}

		@Override
		public void func_179401_a(MerchantRecipeList recipeList, Random random) {
			int buyAmount = 1;
			if (this.buyingPriceInfo != null) {
				buyAmount = this.buyingPriceInfo.func_179412_a(random);
			}

			int emeraldAmount = 1;
			if (this.emeraldPriceInfo != null) {
				emeraldAmount = this.emeraldPriceInfo.func_179412_a(random);
			}

			int sellAmount = 1;
			if (this.sellingPriceInfo != null) {
				sellAmount = this.sellingPriceInfo.func_179412_a(random);
			}

			ItemStack buyItemStack = this.buyingItemStack.func_77946_l();
			buyItemStack.field_77994_a = buyAmount;
			ItemStack sellItemStack = this.sellingItemstack.func_77946_l();
			sellItemStack.field_77994_a = sellAmount;
			recipeList.add(new MerchantRecipe(buyItemStack, new ItemStack(Items.field_151166_bC, emeraldAmount, 0), sellItemStack));
		}
	}

	/**
	 * Copy of {@link EntityVillager.EmeraldForItems}
	 * that takes itemStack as a parameter
	 */
	public static class GiveEmeraldForItems implements EntityVillager.ITradeList {
		public ItemStack buyingItem;
		public EntityVillager.PriceInfo price;

		public GiveEmeraldForItems(ItemStack itemIn, EntityVillager.PriceInfo priceIn) {
			this.buyingItem = itemIn;
			this.price = priceIn;
		}

		/**
		 * Affects the given MerchantRecipeList to possibly add or remove MerchantRecipes.
		 */
		@Override
		public void func_179401_a(MerchantRecipeList recipeList, Random random) {
			int buyAmount = 1;
			if (this.price != null) {
				buyAmount = this.price.func_179412_a(random);
			}

			ItemStack itemToBuy = this.buyingItem.func_77946_l();
			itemToBuy.field_77994_a = buyAmount;
			recipeList.add(new MerchantRecipe(itemToBuy, Items.field_151166_bC));
		}
	}

	/**
	 * Copy of {@link EntityVillager.ListItemForEmeralds}
	 * that copies itemStacks properly
	 */
	public static class GiveItemForEmeralds implements EntityVillager.ITradeList {
		@Nullable
		public EntityVillager.PriceInfo emeraldPriceInfo;
		@Nonnull
		public ItemStack itemToSell;
		@Nullable
		public EntityVillager.PriceInfo sellInfo;

		public GiveItemForEmeralds(@Nullable EntityVillager.PriceInfo emeraldPriceInfo, @Nonnull ItemStack itemToSell, @Nullable EntityVillager.PriceInfo sellInfo) {
			this.emeraldPriceInfo = emeraldPriceInfo;
			this.itemToSell = itemToSell;
			this.sellInfo = sellInfo;
		}

		@Override
		public void func_179401_a(MerchantRecipeList recipeList, Random random) {
			int i = 1;
			if (this.sellInfo != null) {
				i = this.sellInfo.func_179412_a(random);
			}

			int j = 1;
			if (this.emeraldPriceInfo != null) {
				j = this.emeraldPriceInfo.func_179412_a(random);
			}

			ItemStack sellStack = this.itemToSell.func_77946_l();
			sellStack.field_77994_a = i;

			ItemStack emeralds = new ItemStack(Items.field_151166_bC, j);

			recipeList.add(new MerchantRecipe(emeralds, sellStack));
		}
	}

	public static class GiveItemForLogsAndEmeralds implements EntityVillager.ITradeList {
		@Nonnull
		public ItemStack itemToSell;
		@Nonnull
		public EntityVillager.PriceInfo itemInfo;
		@Nonnull
		public EntityVillager.PriceInfo logsInfo;
		@Nonnull
		public EntityVillager.PriceInfo emeraldsInfo;

		public GiveItemForLogsAndEmeralds(@Nonnull ItemStack itemToSell, @Nonnull EntityVillager.PriceInfo itemInfo, @Nonnull EntityVillager.PriceInfo logsInfo, @Nonnull EntityVillager.PriceInfo emeraldsInfo) {
			this.itemToSell = itemToSell;
			this.itemInfo = itemInfo;
			this.logsInfo = logsInfo;
			this.emeraldsInfo = emeraldsInfo;
		}

		@Override
		public void func_179401_a(MerchantRecipeList recipeList, Random random) {
			int itemAmount = this.itemInfo.func_179412_a(random);
			int emeraldsAmount = this.emeraldsInfo.func_179412_a(random);
			int logsAmount = this.logsInfo.func_179412_a(random);

			ItemStack itemToSell = this.itemToSell.func_77946_l();
			itemToSell.field_77994_a = itemAmount;

			int logMeta = random.nextInt(6);
			Block log;
			if (logMeta < 4) {
				log = Blocks.field_150364_r;
			} else {
				log = Blocks.field_150363_s;
				logMeta -= 4;
			}
			ItemStack randomLog = new ItemStack(log, logsAmount, logMeta);

			recipeList.add(new MerchantRecipe(randomLog, new ItemStack(Items.field_151166_bC, emeraldsAmount), itemToSell));
		}
	}
}
