package forestry.core.utils;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.item.ItemStack;

import net.minecraftforge.oredict.OreDictionary;

public class OreDictUtil {
	public static final String ORE_COPPER = "oreCopper";
	public static final String ORE_TIN = "oreTin";
	public static final String ORE_APATITE = "oreApatite";
	public static final String BLOCK_APATITE = "blockApatite";
	public static final String BLOCK_COPPER = "blockCopper";
	public static final String BLOCK_TIN = "blockTin";
	public static final String BLOCK_BRONZE = "blockBronze";
	public static final String GEM_APATITE = "gemApatite";
	public static final String INGOT_COPPER = "ingotCopper";
	public static final String INGOT_TIN = "ingotTin";
	public static final String INGOT_BRONZE = "ingotBronze";
	public static final String GEAR_BRONZE = "gearBronze";
	public static final String GEAR_COPPER = "gearCopper";
	public static final String GEAR_TIN = "gearTin";
	public static final String GEAR_STONE = "gearStone";

	public static final String CRAFTING_TABLE_WOOD = "craftingTableWood";

	public static final String BEE_COMB = "beeComb";
	public static final String DROP_ROYAL_JELLY = "dropRoyalJelly";
	public static final String DROP_HONEYDEW = "dropHoneydew";
	public static final String ITEM_POLLEN = "itemPollen";
	public static final String DROP_HONEY = "dropHoney";
	public static final String ITEM_BEESWAX = "itemBeeswax";

	public static final String TREE_SAPLING = "treeSapling";
	public static final String LOG_WOOD = "logWood";
	public static final String PLANK_WOOD = "plankWood";
	public static final String SLAB_WOOD = "slabWood";
	public static final String FENCE_WOOD = "fenceWood";
	public static final String FENCE_GATE_WOOD = "fenceGateWood";
	public static final String STAIR_WOOD = "stairWood";
	public static final String DOOR_WOOD = "doorWood";
	public static final String TREE_LEAVES = "treeLeaves";

	public static final String EMPTIED_LETTER_ORE_DICT = "emptiedLetter";

	public static final String DUST_ASH = "dustAsh";
	public static final String BRICK_PEAT = "brickPeat";
	public static final String PULP_WOOD = "pulpWood";

	public static final String CROP_CHERRY = "cropCherry";
	public static final String CROP_WALNUT = "cropWalnut";
	public static final String CROP_CHESTNUT = "cropChestnut";
	public static final String CROP_LEMON = "cropLemon";
	public static final String CROP_PLUM = "cropPlum";
	public static final String CROP_DATE = "cropDate";
	public static final String CROP_PAPAYA = "cropPapaya";

	public static final String PANE_GLASS = "paneGlass";
	public static final String SAND = "sand";
	public static final String CROP_WHEAT = "cropWheat";
	public static final String DUST_REDSTONE = "dustRedstone";
	public static final String GEM_DIAMOND = "gemDiamond";
	public static final String STICK_WOOD = "stickWood";
	public static final String INGOT_GOLD = "ingotGold";
	public static final String INGOT_IRON = "ingotIron";
	public static final String STONE = "stone";
	public static final String DIRT = "dirt";
	public static final String BLOCK_GLASS = "blockGlass";
	public static final String GEM_QUARTZ = "gemQuartz";
	public static final String CHEST_WOOD = "chestWood";
	public static final String LEATHER = "leather";

	/**
	 * Used for ores and metals where conflicts are common.
	 * This way, Forestry can choose whatever is first in the oreDictionary instead of its own metals.
	 * If more mods do this, they will automatically unify on one set of metals.
	 */
	@Nullable
	public static ItemStack getFirstSuitableOre(String oreName) {
		if (OreDictionary.doesOreNameExist(oreName)) {
			List<ItemStack> ores = OreDictionary.getOres(oreName);
			for (ItemStack ore : ores) {
				if (ore != null && ore.func_77973_b() != null && ore.func_77960_j() != OreDictionary.WILDCARD_VALUE) {
					ItemStack oreCopy = ore.func_77946_l();
					oreCopy.field_77994_a = 1;
					return oreCopy;
				}
			}
		}
		return null;
	}
}
