/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.multiblock.IFarmComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.circuits.ISocketable;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.tiles.ITitled;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.gui.ContainerFarm;
import forestry.farming.gui.GuiFarm;
import forestry.farming.models.EnumFarmBlockTexture;
import forestry.farming.multiblock.MultiblockLogicFarm;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileFarm
extends MultiblockTileEntityForestry<MultiblockLogicFarm>
implements IFarmComponent,
IHintSource,
ISocketable,
IStreamableGui,
IErrorLogicSource,
IRestrictedAccess,
ITitled {
    private EnumFarmBlockTexture farmBlockTexture = EnumFarmBlockTexture.BRICK_STONE;

    protected TileFarm() {
        super(new MultiblockLogicFarm());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        this.field_145850_b.func_180496_d(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        this.func_70296_d();
    }

    @Override
    public void onMachineBroken() {
        this.field_145850_b.func_180496_d(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        this.func_70296_d();
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getInternalInventory();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.farmBlockTexture = EnumFarmBlockTexture.getFromCompound(nbttagcompound);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.farmBlockTexture.saveToCompound(nbttagcompound);
        return nbttagcompound;
    }

    public void setFarmBlockTexture(EnumFarmBlockTexture farmBlockTexture) {
        if (this.farmBlockTexture != farmBlockTexture) {
            this.farmBlockTexture = farmBlockTexture;
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public EnumFarmBlockTexture getFarmBlockTexture() {
        return this.farmBlockTexture;
    }

    public EnumFarmBlockType getFarmBlockType() {
        return EnumFarmBlockType.VALUES[this.func_145832_p()];
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        this.farmBlockTexture.saveToCompound(packetData);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        EnumFarmBlockTexture farmBlockTexture = EnumFarmBlockTexture.getFromCompound(packetData);
        this.setFarmBlockTexture(farmBlockTexture);
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"farm");
    }

    @Override
    public int getSocketCount() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getSocketCount();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getSocket(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().setSocket(slot, stack);
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getSocketType();
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getAccessHandler();
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().onSwitchAccess(oldAccess, newAccess);
    }

    @Override
    public String getUnlocalizedTitle() {
        return "for.gui.farm.title";
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiFarm(player, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerFarm(player.field_71071_by, this);
    }
}

