/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IStillRecipe;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.gui.ContainerStill;
import forestry.factory.gui.GuiStill;
import forestry.factory.inventory.InventoryStill;
import forestry.factory.recipes.StillRecipeManager;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileStill
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler {
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    private IStillRecipe currentRecipe;
    private FluidStack bufferedLiquid;

    public TileStill() {
        super("still", 1100, 8000);
        this.setInternalInventory(new InventoryStill(this));
        this.resourceTank = new FilteredTank(10000, StillRecipeManager.recipeFluidInputs);
        this.resourceTank.tankMode = StandardTank.TankMode.INPUT;
        this.productTank = new FilteredTank(10000, StillRecipeManager.recipeFluidOutputs);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this, this.resourceTank, this.productTank);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        if (this.bufferedLiquid != null) {
            NBTTagCompound buffer = new NBTTagCompound();
            this.bufferedLiquid.writeToNBT(buffer);
            nbttagcompound.func_74782_a("Buffer", (NBTBase)buffer);
        }
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("Buffer")) {
            NBTTagCompound buffer = nbttagcompound.func_74775_l("Buffer");
            this.bufferedLiquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2);
            FluidStack fluidStack = this.productTank.getFluid();
            if (fluidStack != null) {
                FluidHelper.fillContainers(this.tankManager, (IInventory)this, 1, 0, fluidStack.getFluid());
            }
        }
    }

    @Override
    public boolean workCycle() {
        int cycles = this.currentRecipe.getCyclesPerUnit();
        FluidStack output = this.currentRecipe.getOutput();
        FluidStack product = new FluidStack(output, output.amount * cycles);
        this.productTank.fill(product, true);
        this.bufferedLiquid = null;
        return true;
    }

    private void checkRecipe() {
        FluidStack recipeLiquid;
        FluidStack fluidStack = recipeLiquid = this.bufferedLiquid != null ? this.bufferedLiquid : this.resourceTank.getFluid();
        if (!StillRecipeManager.matches(this.currentRecipe, recipeLiquid)) {
            this.currentRecipe = StillRecipeManager.findMatchingRecipe(recipeLiquid);
            int recipeTime = this.currentRecipe == null ? 0 : this.currentRecipe.getCyclesPerUnit();
            this.setEnergyPerWorkCycle(200 * recipeTime);
            this.setTicksPerWorkCycle(recipeTime);
        }
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasTankSpace = true;
        boolean hasLiquidResource = true;
        if (hasRecipe) {
            hasTankSpace = this.productTank.canFill(this.currentRecipe.getOutput());
            if (this.bufferedLiquid == null) {
                int cycles = this.currentRecipe.getCyclesPerUnit();
                FluidStack input = this.currentRecipe.getInput();
                int drainAmount = cycles * input.amount;
                hasLiquidResource = this.resourceTank.canDrain(drainAmount);
                if (hasLiquidResource) {
                    this.bufferedLiquid = new FluidStack(input, drainAmount);
                    this.resourceTank.drain(drainAmount, true);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasTankSpace, EnumErrorCode.NO_SPACE_TANK);
        errorLogic.setCondition(!hasLiquidResource, EnumErrorCode.NO_RESOURCE_LIQUID);
        return hasRecipe && hasLiquidResource && hasTankSpace;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int quantityMax, boolean doEmpty) {
        return this.tankManager.drain(from, quantityMax, doEmpty);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiStill(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerStill(player.field_71071_by, this);
    }
}

