/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.EnumCamouflageType;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class CamouflageUtil {
    public static void writeCamouflageBlockToNBT(NBTTagCompound data, ICamouflageHandler handler, EnumCamouflageType type) {
        ItemStack camouflageBlock = handler.getCamouflageBlock(type);
        if (camouflageBlock != null) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            camouflageBlock.func_77955_b(nbtTag);
            data.func_74782_a("Camouflage" + type.name(), (NBTBase)nbtTag);
        }
    }

    public static void readCamouflageBlockFromNBT(NBTTagCompound data, ICamouflageHandler handler, EnumCamouflageType type) {
        if (data.func_74764_b("Camouflage" + type.name())) {
            handler.setCamouflageBlock(type, ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Camouflage" + type.name())));
        }
    }

    public static void writeCamouflageBlockToData(DataOutputStreamForestry data, ICamouflageHandler handler, EnumCamouflageType type) throws IOException {
        ItemStack camouflageBlock = handler.getCamouflageBlock(type);
        if (camouflageBlock != null) {
            data.writeShort(1);
            data.writeShort(type.ordinal());
            data.writeItemStack(camouflageBlock);
        } else {
            data.writeShort(0);
        }
    }

    public static void readCamouflageBlockFromData(DataInputStreamForestry data, ICamouflageHandler handler) throws IOException {
        if (data.readShort() == 1) {
            handler.setCamouflageBlock(EnumCamouflageType.VALUES[data.readShort()], data.readItemStack());
        }
    }

    public static ICamouflageHandler getCamouflageHandler(IBlockAccess world, BlockPos pos) {
        IMultiblockComponent component;
        if (pos == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IMultiblockComponent && (component = (IMultiblockComponent)tile).getMultiblockLogic().getController() instanceof ICamouflageHandler) {
            return (ICamouflageHandler)((Object)component.getMultiblockLogic().getController());
        }
        if (tile instanceof ICamouflageHandler) {
            return (ICamouflageHandler)tile;
        }
        return null;
    }

    public static ItemStack getCamouflageBlock(IBlockAccess world, BlockPos pos) {
        ICamouflageHandler handler = CamouflageUtil.getCamouflageHandler(world, pos);
        if (handler == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICamouflagedTile) {
            ICamouflagedTile block = (ICamouflagedTile)tile;
            return handler.getCamouflageBlock(block.getCamouflageType());
        }
        return null;
    }
}

