/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.farming.logic;

import java.util.Collection;
import java.util.Stack;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockBogEarth;

public class FarmLogicPeat extends FarmLogicWatered {
	private static final ItemStack bogEarth = PluginCore.blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, 1);

	public FarmLogicPeat() {
		super(bogEarth, PluginCore.blocks.bogEarth.func_176223_P());
	}

	@Override
	public boolean isAcceptedGround(IBlockState blockState) {
		if (super.isAcceptedGround(blockState)) {
			return true;
		}

		return blockState.func_177230_c() == PluginCore.blocks.bogEarth;
	}

	@Override
	public int getFertilizerConsumption() {
		return 2;
	}

	@Override
	public String getName() {
		if (isManual) {
			return "Manual Peat Bog";
		} else {
			return "Managed Peat Bog";
		}
	}

	@Override
	public boolean isAcceptedGermling(ItemStack itemstack) {
		return false;
	}

	@Override
	public boolean isAcceptedWindfall(ItemStack stack) {
		return false;
	}

	@Override
	public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
		Stack<ICrop> crops = new Stack<>();
		for (int i = 0; i < extent; i++) {
			BlockPos position = translateWithOffset(pos, direction, i);
			IBlockState blockState = world.func_180495_p(position);
			Block block = blockState.func_177230_c();
			if (!(block instanceof BlockBogEarth)) {
				continue;
			}

			BlockBogEarth.SoilType soilType = BlockBogEarth.getTypeFromState(blockState);

			if (soilType == BlockBogEarth.SoilType.PEAT) {
				crops.push(new CropPeat(world, position));
			}
		}
		return crops;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public Item getItem() {
		return PluginCore.items.peat;
	}

}
