/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.slab;

import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.property.PropertyVanillaWoodType;
import forestry.arboriculture.blocks.slab.BlockForestrySlab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class BlockFireproofVanillaSlab
extends BlockForestrySlab<EnumVanillaWoodType>
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    public static List<BlockFireproofVanillaSlab> create(final boolean doubleSlab) {
        ArrayList<BlockFireproofVanillaSlab> blocks = new ArrayList<BlockFireproofVanillaSlab>();
        PropertyVanillaWoodType[] variants = PropertyVanillaWoodType.create("variant", 8);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyVanillaWoodType variant = variants[i];
            BlockFireproofVanillaSlab block = new BlockFireproofVanillaSlab(i){

                @Nonnull
                public PropertyVanillaWoodType getVariant() {
                    return variant;
                }

                public boolean func_176552_j() {
                    return doubleSlab;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockFireproofVanillaSlab(int blockNumber) {
        super(true, blockNumber);
    }

    @Override
    @Nonnull
    public EnumVanillaWoodType getWoodType(int meta) {
        int variantMeta = (meta & 7) + this.getBlockNumber() * 8;
        return EnumVanillaWoodType.byMetadata(variantMeta);
    }
}

