/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenEbony
extends WorldGenTree {
    public WorldGenEbony(ITreeGenData tree) {
        super(tree, 10, 4);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        int offset = (this.girth - 1) / 2;
        int trunksGenerated = 0;
        for (int x = -offset; x < -offset + this.girth; ++x) {
            for (int z = -offset; z < -offset + this.girth; ++z) {
                if (rand.nextFloat() < 0.6f) {
                    for (int y = 0; y < this.height; ++y) {
                        WorldGenHelper.addBlock(world, startPos.func_177982_a(x, y, z), wood, WorldGenHelper.EnumReplaceMode.ALL);
                        if (y > this.height / 2 && rand.nextFloat() < 0.1f * (float)(10 / this.height)) break;
                    }
                    ++trunksGenerated;
                    continue;
                }
                for (int i = 0; i < 1; ++i) {
                    world.func_175698_g(new BlockPos(x, i, z));
                }
            }
        }
        if (trunksGenerated <= 0) {
            WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, 1, 0, 0.6f, null, 0.0f);
        }
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        for (int times = 0; times < 2 * this.height; ++times) {
            int h = 2 * this.girth + rand.nextInt(this.height - this.girth);
            if (rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + rand.nextInt(this.height / 2);
            }
            int x_off = -this.girth + rand.nextInt(2 * this.girth);
            int y_off = -this.girth + rand.nextInt(2 * this.girth);
            BlockPos center = startPos.func_177982_a(x_off, h, y_off);
            int radius = 1 + rand.nextInt(this.girth);
            WorldGenHelper.generateSphere(world, center, radius, leaf, WorldGenHelper.EnumReplaceMode.AIR);
        }
    }
}

