/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Translator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderNone
implements IFruitProvider {
    private static final HashMap<String, OverlayType> overlayTypes = new HashMap();
    private final String unlocalizedDescription;
    private final IFruitFamily family;
    protected int ripeningPeriod = 10;
    private OverlayType overlay = null;

    public FruitProviderNone(String unlocalizedDescription, IFruitFamily family) {
        this.unlocalizedDescription = unlocalizedDescription;
        this.family = family;
    }

    public IFruitProvider setOverlay(String ident) {
        this.overlay = overlayTypes.get(ident);
        return this;
    }

    @Override
    public IFruitFamily getFamily() {
        return this.family;
    }

    @Override
    @Nonnull
    public List<ItemStack> getFruits(ITreeGenome genome, World world, BlockPos pos, int ripeningTime) {
        return Collections.emptyList();
    }

    @Override
    public boolean requiresFruitBlocks() {
        return false;
    }

    @Override
    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, Random rand, BlockPos pos) {
        return false;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        return 0xFFFFFF;
    }

    @Override
    public int getDecorativeColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean isFruitLeaf(ITreeGenome genome, World world, BlockPos pos) {
        return false;
    }

    @Override
    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }

    @Override
    @Nonnull
    public Map<ItemStack, Float> getProducts() {
        return Collections.emptyMap();
    }

    @Override
    @Nonnull
    public Map<ItemStack, Float> getSpecialty() {
        return Collections.emptyMap();
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal(this.unlocalizedDescription);
    }

    @Override
    public ResourceLocation getSprite(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        if (this.overlay != null) {
            return this.overlay.sprite;
        }
        return null;
    }

    @Override
    public ResourceLocation getDecorativeSprite() {
        if (this.overlay != null) {
            return this.overlay.sprite;
        }
        return null;
    }

    @Override
    public void registerSprites() {
        if (this.overlay != null) {
            TextureMap map = Proxies.common.getClientInstance().func_147117_R();
            map.func_174942_a(this.overlay.sprite);
        }
    }

    @Override
    @Nullable
    public String getModelName() {
        return null;
    }

    @Override
    @Nonnull
    public String getModID() {
        return "Forestry";
    }

    static {
        overlayTypes.put("berries", new OverlayType("berries"));
        overlayTypes.put("pomes", new OverlayType("pomes"));
        overlayTypes.put("nuts", new OverlayType("nuts"));
        overlayTypes.put("citrus", new OverlayType("citrus"));
        overlayTypes.put("plums", new OverlayType("plums"));
    }

    private static class OverlayType {
        public final String ident;
        public final ResourceLocation sprite;

        public OverlayType(String ident) {
            this.ident = ident;
            this.sprite = new ResourceLocation("forestry", "blocks/leaves/fruits." + ident);
        }
    }
}

