/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.flowers.Flower;
import forestry.apiculture.flowers.FlowerRegistry;
import forestry.apiculture.tiles.TileBeeHouse;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.log.BlockArbLog;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockCore;
import forestry.core.config.Constants;
import forestry.core.tiles.TileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillageApiaristHouse
extends StructureVillagePieces.House1 {
    private static final Random random = new Random();
    private int averageGroundLevel = -1;
    private boolean isInDesert = false;
    private IBlockState planks;
    private IBlockState slabs;
    private IBlockState logs;
    private IBlockState stairs;
    private IBlockState fence;
    private IBlockState door;
    private IBlockState fenceGate;

    public VillageApiaristHouse() {
        this.createBuildingBlocks(random);
    }

    public VillageApiaristHouse(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing facing) {
        super(startPiece, componentType, random, boundingBox, facing);
        this.isInDesert = startPiece.field_74927_b;
        this.createBuildingBlocks(random);
    }

    private void createBuildingBlocks(Random random) {
        boolean fireproof = random.nextInt(4) == 0;
        Enum woodType = ForestryAPI.enabledPlugins.contains("forestry.arboriculture") ? EnumForestryWoodType.getRandom(random) : EnumVanillaWoodType.getRandom(random);
        IWoodAccess woodAccess = TreeManager.woodAccess;
        this.logs = woodAccess.getBlock((IWoodType)((Object)woodType), WoodBlockKind.LOG, fireproof).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        this.planks = woodAccess.getBlock((IWoodType)((Object)woodType), WoodBlockKind.PLANKS, fireproof);
        this.slabs = woodAccess.getBlock((IWoodType)((Object)woodType), WoodBlockKind.SLAB, fireproof);
        this.stairs = woodAccess.getBlock((IWoodType)((Object)woodType), WoodBlockKind.STAIRS, fireproof);
        this.fence = woodAccess.getBlock((IWoodType)((Object)woodType), WoodBlockKind.FENCE, fireproof);
        this.door = woodAccess.getBlock((IWoodType)((Object)woodType), WoodBlockKind.DOOR, false);
        this.fenceGate = woodAccess.getBlock((IWoodType)((Object)woodType), WoodBlockKind.FENCE_GATE, fireproof);
    }

    public static VillageApiaristHouse buildComponent(StructureVillagePieces.Start startPiece, List<StructureComponent> par1List, Random random, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        StructureBoundingBox bbox = StructureBoundingBox.func_175897_a((int)structureMinX, (int)structureMinY, (int)structureMinZ, (int)0, (int)0, (int)0, (int)10, (int)9, (int)11, (EnumFacing)facing);
        if (!VillageApiaristHouse.func_74895_a((StructureBoundingBox)bbox) || StructureComponent.func_74883_a(par1List, (StructureBoundingBox)bbox) != null) {
            return null;
        }
        return new VillageApiaristHouse(startPiece, componentType, random, bbox, facing);
    }

    public boolean func_74875_a(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox structBoundingBox) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, structBoundingBox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 8 - 1, 0);
        }
        this.func_175804_a(world, structBoundingBox, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(world, structBoundingBox, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.buildGarden(world, structBoundingBox);
        this.func_175804_a(world, structBoundingBox, 1, 1, 6, 1, 1, 10, this.fence, this.fence, false);
        this.func_175804_a(world, structBoundingBox, 8, 1, 6, 8, 1, 10, this.fence, this.fence, false);
        this.func_175804_a(world, structBoundingBox, 2, 1, 10, 7, 1, 10, this.fence, this.fence, false);
        this.func_175811_a(world, this.fenceGate.func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)EnumFacing.EAST), 8, 1, 8, structBoundingBox);
        this.func_175811_a(world, this.fenceGate.func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)EnumFacing.EAST), 1, 1, 8, structBoundingBox);
        this.func_175811_a(world, this.fenceGate.func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)EnumFacing.NORTH), 4, 1, 10, structBoundingBox);
        this.plantFlowerGarden(world, structBoundingBox, 2, 1, 5, 7, 1, 9);
        this.buildApiaries(world, structBoundingBox);
        IBlockState slabFloor = this.slabs.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_175804_a(world, structBoundingBox, 2, 0, 1, 6, 0, 4, slabFloor, slabFloor, false);
        this.func_175804_a(world, structBoundingBox, 1, 0, 1, 1, 0, 4, this.planks, this.planks, false);
        this.func_175804_a(world, structBoundingBox, 7, 0, 1, 7, 0, 4, this.planks, this.planks, false);
        IBlockState cobblestoneState = Blocks.field_150347_e.func_176223_P();
        this.func_175804_a(world, structBoundingBox, 0, 0, 0, 0, 2, 5, cobblestoneState, cobblestoneState, false);
        this.func_175804_a(world, structBoundingBox, 8, 0, 0, 8, 2, 5, cobblestoneState, cobblestoneState, false);
        this.func_175804_a(world, structBoundingBox, 1, 0, 0, 7, 1, 0, cobblestoneState, cobblestoneState, false);
        this.func_175804_a(world, structBoundingBox, 1, 0, 5, 7, 1, 5, cobblestoneState, cobblestoneState, false);
        this.func_175804_a(world, structBoundingBox, 0, 3, 0, 0, 3, 5, this.planks, this.planks, false);
        this.func_175804_a(world, structBoundingBox, 8, 3, 0, 8, 3, 5, this.planks, this.planks, false);
        this.func_175804_a(world, structBoundingBox, 1, 2, 0, 7, 3, 0, this.planks, this.planks, false);
        this.func_175804_a(world, structBoundingBox, 1, 2, 5, 7, 3, 5, this.planks, this.planks, false);
        IBlockState slabCeiling = this.slabs.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
        this.func_175804_a(world, structBoundingBox, 1, 4, 1, 7, 4, 4, slabCeiling, slabCeiling, false);
        IBlockState logBracing = this.logs.func_177226_a((IProperty)BlockArbLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        this.func_175804_a(world, structBoundingBox, 0, 4, 1, 8, 4, 1, logBracing, logBracing, false);
        this.func_175804_a(world, structBoundingBox, 0, 4, 4, 8, 4, 4, logBracing, logBracing, false);
        this.func_175804_a(world, structBoundingBox, 0, 5, 2, 8, 5, 3, this.planks, this.planks, false);
        this.func_175811_a(world, this.planks, 0, 4, 2, structBoundingBox);
        this.func_175811_a(world, this.planks, 0, 4, 3, structBoundingBox);
        this.func_175811_a(world, this.planks, 8, 4, 2, structBoundingBox);
        this.func_175811_a(world, this.planks, 8, 4, 3, structBoundingBox);
        this.buildRoof(world, structBoundingBox);
        this.func_175811_a(world, this.planks, 0, 2, 1, structBoundingBox);
        this.func_175811_a(world, this.planks, 0, 2, 4, structBoundingBox);
        this.func_175811_a(world, this.planks, 8, 2, 1, structBoundingBox);
        this.func_175811_a(world, this.planks, 8, 2, 4, structBoundingBox);
        IBlockState glassPaneState = Blocks.field_150410_aZ.func_176223_P();
        this.func_175811_a(world, glassPaneState, 0, 2, 2, structBoundingBox);
        this.func_175811_a(world, glassPaneState, 0, 2, 3, structBoundingBox);
        IBlockState eastStairs = this.stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
        this.func_175811_a(world, eastStairs, -1, 3, 2, structBoundingBox);
        this.func_175811_a(world, eastStairs, -1, 3, 3, structBoundingBox);
        this.func_175811_a(world, glassPaneState, 8, 2, 2, structBoundingBox);
        this.func_175811_a(world, glassPaneState, 8, 2, 3, structBoundingBox);
        IBlockState westStairs = this.stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
        this.func_175811_a(world, westStairs, 9, 3, 2, structBoundingBox);
        this.func_175811_a(world, westStairs, 9, 3, 3, structBoundingBox);
        this.func_175811_a(world, glassPaneState, 2, 2, 5, structBoundingBox);
        this.func_175811_a(world, glassPaneState, 3, 2, 5, structBoundingBox);
        this.func_175811_a(world, glassPaneState, 4, 2, 5, structBoundingBox);
        this.func_175811_a(world, glassPaneState, 5, 2, 0, structBoundingBox);
        this.func_175811_a(world, glassPaneState, 6, 2, 5, structBoundingBox);
        if (random.nextInt(2) == 0) {
            IBlockState escritoireBlock = PluginCore.blocks.escritoire.func_176223_P().func_177226_a((IProperty)BlockCore.FACING, (Comparable)EnumFacing.EAST);
            this.func_175811_a(world, escritoireBlock, 1, 1, 3, structBoundingBox);
        }
        IBlockState airState = Blocks.field_150350_a.func_176223_P();
        this.func_175811_a(world, this.door.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH), 2, 1, 0, structBoundingBox);
        this.func_175811_a(world, this.door.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 2, 2, 0, structBoundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH), 2, 3, 1, structBoundingBox);
        if (this.isAirBlockAtCurrentPosition(world, new BlockPos(2, 0, -1), structBoundingBox) && !this.isAirBlockAtCurrentPosition(world, new BlockPos(2, -1, -1), structBoundingBox)) {
            this.func_175811_a(world, this.stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 2, 0, -1, structBoundingBox);
        }
        this.func_175811_a(world, airState, 6, 1, 5, structBoundingBox);
        this.func_175811_a(world, airState, 6, 2, 5, structBoundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 6, 3, 4, structBoundingBox);
        this.func_175811_a(world, this.door.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH), 6, 1, 5, structBoundingBox);
        this.func_175811_a(world, this.door.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 6, 2, 5, structBoundingBox);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_74871_b(world, j, 7, i, structBoundingBox);
                this.func_175808_b(world, Blocks.field_150347_e.func_176223_P(), j, -1, i, structBoundingBox);
            }
        }
        this.func_186167_a(world, structBoundingBox, random, 7, 1, 3, Constants.VILLAGE_NATURALIST_LOOT_KEY);
        this.func_175804_a(world, structBoundingBox, 1, 1, 1, 1, 3, 1, this.fence, this.fence, false);
        this.func_175804_a(world, structBoundingBox, 1, 1, 4, 1, 3, 4, this.fence, this.fence, false);
        this.func_175804_a(world, structBoundingBox, 7, 1, 1, 7, 3, 1, this.fence, this.fence, false);
        this.func_175804_a(world, structBoundingBox, 7, 1, 4, 7, 3, 4, this.fence, this.fence, false);
        this.func_74893_a(world, this.field_74887_e, 2, 1, 2, 2);
        return true;
    }

    private void buildRoof(World world, StructureBoundingBox structBoundingBox) {
        for (int z = -1; z <= 2; ++z) {
            for (int x = 0; x <= 8; ++x) {
                IBlockState northStairs = this.stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
                this.func_175811_a(world, northStairs, x, 4 + z, z, structBoundingBox);
                IBlockState southStairs = this.stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
                this.func_175811_a(world, southStairs, x, 4 + z, 5 - z, structBoundingBox);
            }
        }
    }

    private void buildGarden(World world, StructureBoundingBox box) {
        Block ground = Blocks.field_150346_d;
        if (this.isInDesert) {
            ground = Blocks.field_150354_m;
        }
        for (int i = 1; i <= 8; ++i) {
            for (int j = 6; j <= 10; ++j) {
                this.func_175808_b(world, ground.func_176223_P(), i, 0, j, box);
            }
        }
    }

    private void plantFlowerGarden(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.isInDesert) {
            this.func_175811_a(world, Blocks.field_150434_aF.func_176223_P(), 4, 1, 7, box);
            return;
        }
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    IBlockState blockState;
                    int zCoord;
                    int yCoord;
                    int xCoord;
                    BlockPos pos;
                    if (!world.field_73012_v.nextBoolean() || !Blocks.field_150328_O.func_180671_f(world, pos = new BlockPos(xCoord = this.func_74865_a(j, k), yCoord = this.func_74862_a(i), zCoord = this.func_74873_b(j, k)), blockState = world.func_180495_p(pos))) continue;
                    FlowerRegistry flowerRegistry = (FlowerRegistry)FlowerManager.flowerRegistry;
                    Flower flower = flowerRegistry.getRandomPlantableFlower("flowersVanilla", world.field_73012_v);
                    this.func_175811_a(world, flower.getBlock().func_176203_a(flower.getMeta()), j, i, k, box);
                }
            }
        }
    }

    private void buildApiaries(World world, StructureBoundingBox box) {
        this.populateApiary(world, box, new BlockPos(3, 1, 8));
        this.populateApiary(world, box, new BlockPos(6, 1, 8));
    }

    private void populateApiary(World world, StructureBoundingBox box, BlockPos pos) {
        int zCoord;
        int yCoord;
        int xCoord = this.func_74865_a(pos.func_177958_n(), pos.func_177952_p());
        BlockPos posNew = new BlockPos(xCoord, yCoord = this.func_74862_a(pos.func_177956_o()), zCoord = this.func_74873_b(pos.func_177958_n(), pos.func_177952_p()));
        if (!box.func_175898_b((Vec3i)posNew)) {
            return;
        }
        IBlockState blockState = world.func_180495_p(posNew);
        if (PluginApiculture.blocks.beeHouse == blockState.func_177230_c() || !world.func_175667_e(posNew.func_177977_b())) {
            return;
        }
        IBlockState beeHouseDefaultState = PluginApiculture.blocks.beeHouse.func_176223_P();
        world.func_180501_a(posNew, beeHouseDefaultState, 2);
        TileBeeHouse beeHouse = TileUtil.getTile((IBlockAccess)world, posNew, TileBeeHouse.class);
        if (beeHouse == null) {
            return;
        }
        ItemStack randomVillagePrincess = VillageApiaristHouse.getRandomVillageBeeStack(world, posNew, EnumBeeType.PRINCESS);
        beeHouse.getBeeInventory().setQueen(randomVillagePrincess);
        ItemStack randomVillageDrone = VillageApiaristHouse.getRandomVillageBeeStack(world, posNew, EnumBeeType.DRONE);
        beeHouse.getBeeInventory().setDrone(randomVillageDrone);
    }

    private static ItemStack getRandomVillageBeeStack(World world, BlockPos pos, EnumBeeType beeType) {
        IBee randomVillageBee = VillageApiaristHouse.getRandomVillageBee(world, pos);
        return BeeManager.beeRoot.getMemberStack(randomVillageBee, beeType);
    }

    private static IBee getRandomVillageBee(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        List<IBeeGenome> candidates = BeeManager.uncommonVillageBees != null && !BeeManager.uncommonVillageBees.isEmpty() && world.field_73012_v.nextDouble() < 0.2 ? BeeManager.uncommonVillageBees : BeeManager.commonVillageBees;
        EnumTemperature biomeTemperature = EnumTemperature.getFromBiome(biome, world, pos);
        EnumHumidity biomeHumidity = EnumHumidity.getFromValue(biome.func_76727_i());
        ArrayList<IBeeGenome> valid = new ArrayList<IBeeGenome>();
        for (IBeeGenome genome : candidates) {
            if (!VillageApiaristHouse.checkBiomeHazard(genome, biomeTemperature, biomeHumidity)) continue;
            valid.add(genome);
        }
        if (valid.isEmpty()) {
            IBeeGenome genome;
            int index = world.field_73012_v.nextInt(BeeManager.commonVillageBees.size());
            genome = BeeManager.commonVillageBees.get(index);
            return BeeManager.beeRoot.getBee(genome);
        }
        return BeeManager.beeRoot.getBee((IBeeGenome)valid.get(world.field_73012_v.nextInt(valid.size())));
    }

    private static boolean checkBiomeHazard(IBeeGenome genome, EnumTemperature biomeTemperature, EnumHumidity biomeHumidity) {
        IAlleleBeeSpecies species = genome.getPrimary();
        return AlleleManager.climateHelper.isWithinLimits(biomeTemperature, biomeHumidity, species.getTemperature(), genome.getToleranceTemp(), species.getHumidity(), genome.getToleranceHumid());
    }

    protected int func_180779_c(int villagerCount, int currentVillagerProfession) {
        FMLControlledNamespacedRegistry registry = (FMLControlledNamespacedRegistry)VillagerRegistry.instance().getRegistry();
        if (villagerCount <= 0) {
            return registry.getId((IForgeRegistryEntry)PluginApiculture.villagerApiarist);
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.arboriculture")) {
            return registry.getId((IForgeRegistryEntry)PluginArboriculture.villagerArborist);
        }
        return currentVillagerProfession;
    }

    private boolean isAirBlockAtCurrentPosition(World world, BlockPos pos, StructureBoundingBox box) {
        IBlockState blockStateFromPos = this.func_175807_a(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), box);
        return blockStateFromPos.func_177230_c().isAir(blockStateFromPos, (IBlockAccess)world, pos);
    }
}

