/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.IFlowerProvider;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.utils.VectUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class HasFlowersCache
implements INbtWritable,
INbtReadable,
IStreamable {
    private static final String nbtKey = "hasFlowerCache";
    private static final String nbtKeyFlowers = "flowers";
    private static final String nbtKeyCooldown = "cooldown";
    private static final Random random = new Random();
    private static final int flowerCheckInterval = 128;
    private final int flowerCheckTime = random.nextInt(128);
    @Nonnull
    private List<BlockPos> flowerCoords = new ArrayList<BlockPos>();
    private int cooldown = 0;
    private boolean needsSync = false;

    public boolean hasFlowers(IBee queen, IBeeHousing beeHousing) {
        IFlowerProvider flowerProvider = queen.getGenome().getFlowerProvider();
        String flowerType = flowerProvider.getFlowerType();
        World world = beeHousing.getWorldObj();
        if (!this.flowerCoords.isEmpty()) {
            if (world.func_82737_E() % 128L != (long)this.flowerCheckTime) {
                return true;
            }
            IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(beeHousing);
            BlockPos housingCoords = beeHousing.getCoordinates();
            Vec3i genomeTerritory = queen.getGenome().getTerritory();
            float housingModifier = beeModifier.getTerritoryModifier(queen.getGenome(), 1.0f);
            BlockPos area = VectUtil.scale(genomeTerritory, housingModifier * 3.0f);
            BlockPos min = VectUtil.scale((Vec3i)area, -0.5f).func_177971_a((Vec3i)housingCoords);
            BlockPos max = VectUtil.scale((Vec3i)area, 0.5f).func_177971_a((Vec3i)housingCoords);
            for (BlockPos flowerPos : this.flowerCoords) {
                if (HasFlowersCache.isFlowerValid(world, flowerPos, flowerType, min, max)) continue;
                this.cooldown = 0;
                break;
            }
        }
        if (this.cooldown <= 0) {
            List<BlockPos> newFlowerCoords = FlowerManager.flowerRegistry.getAcceptedFlowerCoordinates(beeHousing, queen, flowerType, 5);
            this.cooldown = 550;
            if (!this.flowerCoords.equals(newFlowerCoords)) {
                this.flowerCoords = newFlowerCoords;
                this.needsSync = true;
            }
        } else {
            --this.cooldown;
        }
        return !this.flowerCoords.isEmpty();
    }

    public boolean needsSync() {
        boolean returnVal = this.needsSync;
        this.needsSync = false;
        return returnVal;
    }

    @Nonnull
    public List<BlockPos> getFlowerCoords() {
        return Collections.unmodifiableList(this.flowerCoords);
    }

    private static boolean isFlowerValid(World world, BlockPos flowerCoords, String flowerType, BlockPos min, BlockPos max) {
        if (!HasFlowersCache.isFlowerCoordInRange(flowerCoords, min, max)) {
            return false;
        }
        return FlowerManager.flowerRegistry.isAcceptedFlower(flowerType, world, flowerCoords);
    }

    private static boolean isFlowerCoordInRange(BlockPos flowerCoords, BlockPos min, BlockPos max) {
        return flowerCoords.func_177958_n() >= min.func_177958_n() && flowerCoords.func_177958_n() <= max.func_177958_n() && flowerCoords.func_177956_o() >= min.func_177956_o() && flowerCoords.func_177956_o() <= max.func_177956_o() && flowerCoords.func_177952_p() >= min.func_177952_p() && flowerCoords.func_177952_p() <= max.func_177952_p();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int[] flowersList;
        if (!nbttagcompound.func_74764_b(nbtKey)) {
            return;
        }
        NBTTagCompound hasFlowerCacheNBT = nbttagcompound.func_74775_l(nbtKey);
        if (hasFlowerCacheNBT.func_74764_b(nbtKeyFlowers) && (flowersList = hasFlowerCacheNBT.func_74759_k(nbtKeyFlowers)) != null && flowersList.length % 3 == 0) {
            int flowerCount = flowersList.length / 3;
            for (int i = 0; i < flowerCount; ++i) {
                BlockPos flowerPos = new BlockPos(flowersList[i], flowersList[i + 1], flowersList[i + 2]);
                this.flowerCoords.add(flowerPos);
            }
        }
        this.cooldown = hasFlowerCacheNBT.func_74762_e(nbtKeyCooldown);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound hasFlowerCacheNBT = new NBTTagCompound();
        if (!this.flowerCoords.isEmpty()) {
            int[] flowersList = new int[this.flowerCoords.size() * 3];
            int i = 0;
            for (BlockPos flowerPos : this.flowerCoords) {
                flowersList[i] = flowerPos.func_177958_n();
                flowersList[i + 1] = flowerPos.func_177956_o();
                flowersList[i + 2] = flowerPos.func_177952_p();
                ++i;
            }
            hasFlowerCacheNBT.func_74783_a(nbtKeyFlowers, flowersList);
        }
        hasFlowerCacheNBT.func_74768_a(nbtKeyCooldown, this.cooldown);
        nbttagcompound.func_74782_a(nbtKey, (NBTBase)hasFlowerCacheNBT);
        return nbttagcompound;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        int size = this.flowerCoords.size();
        data.writeVarInt(size);
        if (size > 0) {
            for (BlockPos pos : this.flowerCoords) {
                data.writeVarInt(pos.func_177958_n());
                data.writeVarInt(pos.func_177956_o());
                data.writeVarInt(pos.func_177952_p());
            }
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.flowerCoords.clear();
        for (int size = data.readVarInt(); size > 0; --size) {
            BlockPos pos = new BlockPos(data.readVarInt(), data.readVarInt(), data.readVarInt());
            this.flowerCoords.add(pos);
        }
    }
}

