/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.entities;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

import net.minecraftforge.common.IPlantable;

public class AIButterflyRest extends AIButterflyBase {

	public AIButterflyRest(EntityButterfly entity) {
		super(entity);
		func_75248_a(3);
	}

	@Override
	public boolean func_75250_a() {

		if (entity.getExhaustion() < EntityButterfly.EXHAUSTION_REST
				&& entity.canFly()) {
			return false;
		}

		int x = (int) entity.field_70165_t;
		int y = (int) Math.floor(entity.field_70163_u);
		int z = (int) entity.field_70161_v;
		BlockPos pos = new BlockPos(x, y, z);

		if (!canLand(pos)) {
			return false;
		}

		pos = pos.func_177982_a(x, -1, z);
		if (entity.field_70170_p.func_175623_d(pos)) {
			return false;
		}
		IBlockState blockState = entity.field_70170_p.func_180495_p(pos);
		if (blockState.func_177230_c().func_149688_o(blockState).func_76224_d()) {
			return false;
		}
		if (!entity.getButterfly().isAcceptedEnvironment(entity.field_70170_p, x, pos.func_177956_o(), z)) {
			return false;
		}

		entity.setDestination(null);
		entity.setState(EnumButterflyState.RESTING);
		return true;
	}

	@Override
	public boolean func_75253_b() {
		if (entity.getExhaustion() <= 0 && entity.canFly()) {
			return false;
		}
		return !entity.func_70090_H();
	}

	@Override
	public void func_75249_e() {
	}

	@Override
	public void func_75251_c() {
	}

	@Override
	public void func_75246_d() {
		entity.changeExhaustion(-1);
	}

	private boolean canLand(BlockPos pos) {
		IBlockState blockState = entity.field_70170_p.func_180495_p(pos);
		Block block = blockState.func_177230_c();
		if (!block.func_176205_b(entity.field_70170_p, pos)) {
			return false;
		}
		if (isPlant(blockState)) {
			return true;
		}

		IBlockState blockStateBelow = entity.field_70170_p.func_180495_p(pos.func_177977_b());
		Block blockBelow = blockStateBelow.func_177230_c();
		return isRest(blockBelow) || blockBelow.isLeaves(blockStateBelow, entity.field_70170_p, pos.func_177977_b());
	}

	private static boolean isRest(Block block) {
		if (block instanceof BlockFence) {
			return true;
		}
		return block instanceof BlockWall;
	}

	private static boolean isPlant(IBlockState blockState) {
		Block block = blockState.func_177230_c();
		if (block instanceof BlockFlower) {
			return true;
		} else if (block instanceof IPlantable) {
			return true;
		} else if (block instanceof IGrowable) {
			return true;
		} else if (block.func_149688_o(blockState) == Material.field_151585_k) {
			return true;
		}
		return false;
	}
}
