/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.jei;

import com.google.common.collect.ArrayListMultimap;
import forestry.core.utils.Translator;
import java.text.NumberFormat;
import java.util.List;
import mezz.jei.api.gui.ITooltipCallback;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ForestryTooltipCallback
implements ITooltipCallback<ItemStack> {
    private final ArrayListMultimap<Integer, String> tooltips = ArrayListMultimap.create();

    public void addToTooltip(int index, List<String> tooltip) {
        this.tooltips.get((Object)index).addAll(tooltip);
    }

    public void addToTooltip(int index, String tooltip) {
        this.tooltips.get((Object)index).add(tooltip);
    }

    public List<String> getTooltip(int index) {
        return this.tooltips.get((Object)index);
    }

    public void onTooltip(int index, boolean input, ItemStack ingredient, List<String> tooltip) {
        List tip = this.tooltips.get((Object)index);
        if (!tip.isEmpty()) {
            tooltip.addAll(tip);
        }
    }

    public void clearTooltip() {
        this.tooltips.clear();
    }

    public void addChanceTooltip(int index, float chance) {
        if (chance <= 0.0f) {
            this.tooltips.get((Object)index).add(TextFormatting.GRAY + String.format(Translator.translateToLocal("forestry.jei.chance"), Translator.translateToLocal("forestry.jei.chance.never")));
        } else if (chance < 0.01f) {
            this.tooltips.get((Object)index).add(TextFormatting.GRAY + String.format(Translator.translateToLocal("forestry.jei.chance"), Translator.translateToLocal("forestry.jei.chance.lessThan1")));
        } else if (chance != 1.0f) {
            NumberFormat percentFormat = NumberFormat.getPercentInstance();
            percentFormat.setMaximumFractionDigits(2);
            this.tooltips.get((Object)index).add(TextFormatting.GRAY + String.format(Translator.translateToLocal("forestry.jei.chance"), String.valueOf(percentFormat.format(chance))));
        }
    }
}

