/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.TradeStationInfo;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.utils.StringUtil;
import forestry.mail.gui.ContainerCatalogue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiCatalogue
extends GuiForestry<ContainerCatalogue, IInventory> {
    private static final String boldUnderline = EnumChatFormatting.BOLD.toString() + EnumChatFormatting.UNDERLINE;
    private GuiButton buttonFilter;
    private GuiButton buttonUse;
    private final List<ItemStackWidget> tradeInfoWidgets = new ArrayList<ItemStackWidget>();

    public GuiCatalogue(EntityPlayer player) {
        super(new ResourceLocation("textures/gui/book.png"), new ContainerCatalogue(player), null);
        this.xSize = 192;
        this.ySize = 192;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.add(new GuiButton(2, this.width / 2 + 44, this.guiTop + 150, 12, 20, ">"));
        this.buttonList.add(new GuiButton(3, this.width / 2 - 58, this.guiTop + 150, 12, 20, "<"));
        this.buttonFilter = new GuiButton(4, this.width / 2 - 44, this.guiTop + 150, 42, 20, StringUtil.localize("gui.mail.filter.all"));
        this.buttonList.add(this.buttonFilter);
        this.buttonUse = new GuiButton(5, this.width / 2, this.guiTop + 150, 42, 20, StringUtil.localize("gui.mail.address.copy"));
        this.buttonList.add(this.buttonUse);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.onGuiClosed();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        this.fontRendererObj.drawString(String.format("%s / %s", ((ContainerCatalogue)this.container).getPageNumber(), ((ContainerCatalogue)this.container).getPageCount()), this.guiLeft + this.xSize - 72, this.guiTop + 12, this.fontColor.get("gui.book"));
        this.clearTradeInfoWidgets();
        TradeStationInfo tradeInfo = ((ContainerCatalogue)this.container).getTradeInfo();
        if (tradeInfo != null) {
            this.drawTradePreview(tradeInfo, this.guiLeft + 38, this.guiTop + 30);
            this.buttonUse.enabled = tradeInfo.state.isOk();
        } else {
            this.drawNoTrade(this.guiLeft + 38, this.guiTop + 30);
            this.buttonUse.enabled = false;
        }
        this.buttonFilter.displayString = StringUtil.localize("gui.mail.filter." + ((ContainerCatalogue)this.container).getFilterIdent());
    }

    private void drawNoTrade(int x, int y) {
        this.fontRendererObj.drawSplitString(StringUtil.localize("gui.mail.notrades"), x, y + 18, 119, this.fontColor.get("gui.book"));
    }

    private void drawTradePreview(TradeStationInfo tradeInfo, int x, int y) {
        this.fontRendererObj.drawString(boldUnderline + tradeInfo.address.getName(), x, y, this.fontColor.get("gui.book"));
        this.fontRendererObj.drawString(String.format(StringUtil.localize("gui.mail.willtrade"), tradeInfo.owner.getName()), x, y + 18, this.fontColor.get("gui.book"));
        this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x - this.guiLeft, y - this.guiTop + 28, tradeInfo.tradegood));
        this.fontRendererObj.drawString(StringUtil.localize("gui.mail.tradefor"), x, y + 46, this.fontColor.get("gui.book"));
        for (int i = 0; i < tradeInfo.required.length; ++i) {
            ItemStack itemStack = tradeInfo.required[i];
            this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x - this.guiLeft + i * 18, y - this.guiTop + 56, itemStack));
        }
        if (tradeInfo.state.isOk()) {
            this.fontRendererObj.drawSplitString(EnumChatFormatting.DARK_GREEN + StringUtil.localize("chat.mail." + tradeInfo.state.getIdentifier()), x, y + 82, 119, this.fontColor.get("gui.book"));
        } else {
            this.fontRendererObj.drawSplitString(EnumChatFormatting.DARK_RED + StringUtil.localize("chat.mail." + tradeInfo.state.getIdentifier()), x, y + 82, 119, this.fontColor.get("gui.book"));
        }
    }

    private void addTradeInfoWidget(ItemStackWidget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    protected void actionPerformed(GuiButton button) {
        switch (button.id) {
            case 0: {
                this.mc.thePlayer.closeScreen();
                break;
            }
            case 2: {
                ((ContainerCatalogue)this.container).nextPage();
                break;
            }
            case 3: {
                ((ContainerCatalogue)this.container).previousPage();
                break;
            }
            case 4: {
                ((ContainerCatalogue)this.container).cycleFilter();
                break;
            }
            case 5: {
                TradeStationInfo info = ((ContainerCatalogue)this.container).getTradeInfo();
                if (info != null) {
                    SessionVars.setStringVar("mail.letter.recipient", info.address.getName());
                    SessionVars.setStringVar("mail.letter.addressee", EnumAddressee.TRADER.toString());
                }
                this.mc.thePlayer.closeScreen();
            }
        }
    }
}

