/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.apiculture.tiles.TileCandle;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.StringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockCandle
extends BlockTorch {
    private static final ImmutableMap<String, Integer> colours = ImmutableMap.builder().put((Object)"dyeWhite", (Object)new Color(255, 255, 255).getRGB()).put((Object)"dyeOrange", (Object)new Color(219, 125, 62).getRGB()).put((Object)"dyeMagenta", (Object)new Color(255, 20, 255).getRGB()).put((Object)"dyeLightBlue", (Object)new Color(107, 138, 201).getRGB()).put((Object)"dyeYellow", (Object)new Color(255, 255, 20).getRGB()).put((Object)"dyeLime", (Object)new Color(20, 255, 20).getRGB()).put((Object)"dyePink", (Object)new Color(208, 132, 153).getRGB()).put((Object)"dyeGray", (Object)new Color(74, 74, 74).getRGB()).put((Object)"dyeLightGray", (Object)new Color(154, 161, 161).getRGB()).put((Object)"dyeCyan", (Object)new Color(20, 255, 255).getRGB()).put((Object)"dyePurple", (Object)new Color(126, 61, 181).getRGB()).put((Object)"dyeBlue", (Object)new Color(20, 20, 255).getRGB()).put((Object)"dyeBrown", (Object)new Color(79, 50, 31).getRGB()).put((Object)"dyeGreen", (Object)new Color(53, 70, 27).getRGB()).put((Object)"dyeRed", (Object)new Color(150, 52, 48).getRGB()).put((Object)"dyeBlack", (Object)new Color(20, 20, 20).getRGB()).build();
    private static final Set<Item> lightingItems = new HashSet<Item>(Arrays.asList(Items.flint_and_steel, Items.flint, Item.getItemFromBlock((Block)Blocks.torch)));
    public static final String colourTagName = "colour";
    @SideOnly(value=Side.CLIENT)
    private IIcon litStump;
    @SideOnly(value=Side.CLIENT)
    private IIcon litTip;
    @SideOnly(value=Side.CLIENT)
    private IIcon unlitStump;
    @SideOnly(value=Side.CLIENT)
    private IIcon unlitTip;
    private final ThreadLocal<ItemStack> drop = new ThreadLocal();

    public BlockCandle() {
        this.setHardness(0.0f);
        this.setStepSound(soundTypeWood);
        this.setCreativeTab(Tabs.tabApiculture);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileCandle();
    }

    public int getRenderType() {
        return Proxies.render.getCandleRenderId();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        String fileBase = StringUtil.cleanBlockName((Block)this);
        this.blockIcon = TextureManager.registerTex(register, "stump");
        this.litStump = TextureManager.registerTex(register, fileBase + "StumpLit");
        this.litTip = TextureManager.registerTex(register, fileBase + "TipLit");
        this.unlitStump = TextureManager.registerTex(register, fileBase + "StumpUnlit");
        this.unlitTip = TextureManager.registerTex(register, fileBase + "TipUnlit");
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileCandle && ((TileCandle)tileEntity).isLit()) {
            return 14;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTextureFromPassAndLit(int pass, boolean isLit) {
        IIcon i = pass == 0 ? (isLit ? this.litTip : this.unlitTip) : (isLit ? this.litStump : this.unlitStump);
        return i;
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int facing, float facingX, float facingY, float facingZ) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (!(tileEntity instanceof TileCandle)) {
            return false;
        }
        TileCandle tileCandle = (TileCandle)tileEntity;
        boolean isLit = tileCandle.isLit();
        boolean flag = false;
        boolean toggleLitState = true;
        ItemStack heldItem = player.getCurrentEquippedItem();
        if (!isLit) {
            if (heldItem == null || !lightingItems.contains(heldItem.getItem())) {
                toggleLitState = false;
            } else if (ItemStackUtil.equals((Block)this, heldItem) && BlockCandle.isLit(heldItem)) {
                toggleLitState = true;
            }
        }
        if (heldItem != null) {
            if (ItemStackUtil.equals((Block)this, heldItem)) {
                if (!BlockCandle.isLit(heldItem)) {
                    if (heldItem.hasTagCompound() && heldItem.getTagCompound().hasKey(colourTagName)) {
                        tileCandle.setColour(heldItem.getTagCompound().getInteger(colourTagName));
                    } else {
                        tileCandle.setColour(0xFFFFFF);
                    }
                } else {
                    toggleLitState = true;
                }
                flag = true;
            } else {
                boolean dyed = BlockCandle.tryDye(heldItem, isLit, tileCandle);
                if (dyed) {
                    world.markBlockForUpdate(x, y, z);
                    toggleLitState = false;
                    flag = true;
                }
            }
        }
        if (toggleLitState) {
            tileCandle.setLit(!isLit);
            world.markBlockForUpdate(x, y, z);
            flag = true;
        }
        return flag;
    }

    private static boolean tryDye(ItemStack held, boolean isLit, TileCandle tileCandle) {
        for (Map.Entry colour : colours.entrySet()) {
            String colourName = (String)colour.getKey();
            for (ItemStack stack : OreDictionary.getOres((String)colourName)) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)held, (boolean)true)) continue;
                if (isLit) {
                    tileCandle.setColour((Integer)colour.getValue());
                } else {
                    tileCandle.addColour((Integer)colour.getValue());
                }
                return true;
            }
        }
        return false;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        if (!world.isRemote) {
            ItemStack itemStack = this.getCandleDrop(world, x, y, z);
            this.drop.set(itemStack);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ItemStack dropStack = this.drop.get();
        this.drop.remove();
        if (dropStack == null) {
            dropStack = this.getCandleDrop(world, x, y, z);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        drops.add(dropStack);
        return drops;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getCandleDrop(world, x, y, z);
    }

    private ItemStack getCandleDrop(World world, int x, int y, int z) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (!(tileEntity instanceof TileCandle)) {
            return null;
        }
        TileCandle tileCandle = (TileCandle)tileEntity;
        int colour = tileCandle.getColour();
        int newMeta = tileCandle.isLit() ? 1 : 0;
        ItemStack itemStack = new ItemStack((Block)this, 1, newMeta);
        if (colour != 0xFFFFFF) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.setInteger(colourTagName, colour);
            itemStack.setTagCompound(tag);
        }
        return itemStack;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        TileCandle tileCandle = (TileCandle)world.getTileEntity(x, y, z);
        int colour = BlockCandle.getColourValueFromItemStack(itemStack);
        boolean isLit = BlockCandle.isLit(itemStack);
        tileCandle.setColour(colour);
        tileCandle.setLit(isLit);
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileCandle && ((TileCandle)tileEntity).isLit()) {
            super.randomDisplayTick(world, x, y, z, random);
        }
    }

    private static int getColourValueFromItemStack(ItemStack itemStack) {
        NBTTagCompound tag;
        int value = 0xFFFFFF;
        if (itemStack.hasTagCompound() && (tag = itemStack.getTagCompound()).hasKey(colourTagName)) {
            value = tag.getInteger(colourTagName);
        }
        return value;
    }

    public static boolean isLit(ItemStack itemStack) {
        return itemStack.getItemDamage() > 0;
    }

    public static void addItemToLightingList(Item item) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (!lightingItems.contains(item)) {
            lightingItems.add(item);
        }
    }

    public ItemStack getUnlitCandle(int amount) {
        return new ItemStack((Block)this, amount, 0);
    }

    public ItemStack getLitCandle(int amount) {
        return new ItemStack((Block)this, amount, 1);
    }
}

