/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.FarmableBasicGrowthCraft;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="Growthcraft", name="Growthcraft", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.growthcraft.description")
public class PluginGrowthCraft
extends ForestryPlugin {
    private static final String GC = "Growthcraft";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(GC, "[1.7.10-1.0.0,1.7.10-2.5.0)");
    }

    @Override
    public String getFailMessage() {
        return "GrowthCraft not found";
    }

    @Override
    protected void registerRecipes() {
        ItemStack bambooLeaves;
        Block grapeBlock;
        ItemStack grapes;
        Item comb;
        Block riceBlock;
        Block hopVine;
        ItemStack hops;
        int saplingYield = ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling");
        int juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        int seedamount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        ItemStack appleSeed = GameRegistry.findItemStack((String)"Growthcraft|Apples", (String)"grc.appleSeeds", (int)1);
        ItemStack grapeSeed = GameRegistry.findItemStack((String)"Growthcraft|Grapes", (String)"grc.grapeSeeds", (int)1);
        ItemStack hopSeed = GameRegistry.findItemStack((String)"Growthcraft|Hops", (String)"grc.hopSeeds", (int)1);
        ItemStack riceSeed = GameRegistry.findItemStack((String)"Growthcraft|Rice", (String)"grc.rice", (int)1);
        if (appleSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{appleSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            BackpackManager.backpackItems[2].add(appleSeed);
        }
        if (grapeSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{grapeSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            BackpackManager.backpackItems[2].add(grapeSeed);
        }
        if (hopSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{hopSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            BackpackManager.backpackItems[2].add(hopSeed);
        }
        if (riceSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{riceSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            BackpackManager.backpackItems[2].add(riceSeed);
        }
        if ((hops = GameRegistry.findItemStack((String)"Growthcraft|Hops", (String)"grc.hops", (int)1)) != null) {
            RecipeUtil.addFermenterRecipes(hops, saplingYield, Fluids.BIOMASS);
            BackpackManager.backpackItems[2].add(hops);
        }
        if ((hopVine = GameRegistry.findBlock((String)"Growthcraft|Hops", (String)"grc.hopVine")) != null) {
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicGrowthCraft(hopVine, 3, false, false));
        }
        if ((riceBlock = GameRegistry.findBlock((String)"Growthcraft|Rice", (String)"grc.riceBlock")) != null) {
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicGrowthCraft(riceBlock, 7, true, false));
        }
        if (PluginManager.Module.APICULTURE.isEnabled() && (comb = GameRegistry.findItem((String)"Growthcraft|Bees", (String)"grc.honeyComb")) != null) {
            ItemStack emptyComb = new ItemStack(comb, 1, 0);
            RecipeManagers.centrifugeManager.addRecipe(20, emptyComb, (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f)));
            ItemStack fullComb = new ItemStack(comb, 1, 1);
            RecipeManagers.centrifugeManager.addRecipe(20, fullComb, (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f), (Object)PluginApiculture.items.honeydew.getItemStack(), (Object)Float.valueOf(0.1f)));
        }
        ItemStack bamboo = GameRegistry.findItemStack((String)"Growthcraft|Bamboo", (String)"grc.bamboo", (int)1);
        ItemStack bambooShoot = GameRegistry.findItemStack((String)"Growthcraft|Bamboo", (String)"grc.bambooShoot", (int)1);
        ItemStack bambooShootFood = GameRegistry.findItemStack((String)"Growthcraft|Bamboo", (String)"grc.bambooShootFood", (int)1);
        if (bamboo != null) {
            RecipeUtil.addFermenterRecipes(bamboo, saplingYield, Fluids.BIOMASS);
            BackpackManager.backpackItems[2].add(bamboo);
        }
        if (bambooShoot != null) {
            RecipeUtil.addFermenterRecipes(bambooShoot, saplingYield, Fluids.BIOMASS);
            BackpackManager.backpackItems[2].add(bambooShoot);
        }
        if (bambooShootFood != null) {
            RecipeUtil.addFermenterRecipes(bambooShootFood, saplingYield, Fluids.BIOMASS);
            BackpackManager.backpackItems[2].add(bambooShootFood);
        }
        if ((grapes = GameRegistry.findItemStack((String)"Growthcraft|Grapes", (String)"grc.grapes", (int)1)).getItem() != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{grapes}, Fluids.JUICE.getFluid(juiceAmount));
            BackpackManager.backpackItems[2].add(grapes);
        }
        if ((grapeBlock = GameRegistry.findBlock((String)"Growthcraft|Grapes", (String)"grc.grapeBlock")) != null) {
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicGrowthCraft(grapeBlock, 0, false, true));
        }
        if ((bambooLeaves = GameRegistry.findItemStack((String)"Growthcraft|Bamboo", (String)"grc.bambooLeaves", (int)1)) != null) {
            BackpackManager.backpackItems[2].add(bambooLeaves);
        }
    }
}

