/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenChestnut
extends WorldGenTree {
    public WorldGenChestnut(ITreeGenData tree) {
        super(tree, 7, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
        while (leafSpawn > 4) {
            this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        }
        if (world.rand.nextBoolean()) {
            this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        }
        int branchRadius = this.height / 2;
        List<ChunkCoordinates> branchCoords = this.generateBranches(world, leafSpawn, 0, 0, 0.5f, 0.5f, branchRadius, 2);
        for (ChunkCoordinates branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.posY, branchEnd.posX, branchEnd.posZ, 1.0f, 2, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        this.generateAdjustedCylinder(world, leafSpawn, 1.5f, 1, this.leaf);
    }
}

