/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import cpw.mods.fml.common.Optional;
import forestry.api.multiblock.IFarmComponent;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.utils.InventoryUtil;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import forestry.farming.triggers.FarmingTriggers;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.statements.ITriggerProvider", modid="BuildCraftAPI|statements")
public class TileFarmHatch
extends TileFarm
implements ISidedInventory,
IFarmComponent.Active,
ITriggerProvider {
    private static final ForgeDirection[] dumpDirections = new ForgeDirection[]{ForgeDirection.DOWN};
    private final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.tileCache, new AdjacentInventoryCache.ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            return !(tile instanceof TileFarm) && tile.yCoord < TileFarmHatch.this.yCoord;
        }
    });

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void updateServer(int tickCount) {
        IInventory productInventory;
        if (tickCount % 40 == 0 && !InventoryUtil.moveOneItemToPipe(productInventory = ((MultiblockLogicFarm)this.getMultiblockLogic()).getController().getFarmInventory().getProductInventory(), this.tileCache, dumpDirections)) {
            InventoryUtil.moveItemStack(productInventory, this.inventoryCache.getAdjacentInventories());
        }
    }

    @Override
    public void updateClient(int tickCount) {
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        if (!((MultiblockLogicFarm)this.getMultiblockLogic()).isConnected()) {
            return Collections.emptyList();
        }
        return FarmingTriggers.allExternalTriggers;
    }
}

