/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IHiveDrop;
import forestry.apiculture.genetics.IBeeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HiveDrop
implements IHiveDrop {
    private final IBeeDefinition beeTemplate;
    private final ArrayList<ItemStack> additional = new ArrayList();
    private final int chance;
    private float ignobleShare = 0.0f;

    public HiveDrop(int chance, IBeeDefinition beeTemplate, ItemStack ... bonus) {
        this.beeTemplate = beeTemplate;
        this.chance = chance;
        Collections.addAll(this.additional, bonus);
    }

    public HiveDrop setIgnobleShare(float share) {
        this.ignobleShare = share;
        return this;
    }

    @Override
    public ItemStack getPrincess(World world, int x, int y, int z, int fortune) {
        IBee bee = this.beeTemplate.getIndividual();
        if (world.rand.nextFloat() < this.ignobleShare) {
            bee.setIsNatural(false);
        }
        return BeeManager.beeRoot.getMemberStack(bee, EnumBeeType.PRINCESS.ordinal());
    }

    public List<ItemStack> getDrones(World world, int x, int y, int z, int fortune) {
        ItemStack drone = this.beeTemplate.getMemberStack(EnumBeeType.DRONE);
        return Collections.singletonList(drone);
    }

    public ArrayList<ItemStack> getAdditional(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : this.additional) {
            ret.add(stack.copy());
        }
        return ret;
    }

    @Override
    public int getChance(World world, int x, int y, int z) {
        return this.chance;
    }
}

