/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.genetics.ISpeciesRoot;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.InventoryNaturalistChest;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.TileBase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;

public abstract class TileNaturalistChest
extends TileBase
implements IPagedInventory {
    private static final float lidAngleVariationPerTick = 0.1f;
    private final ISpeciesRoot speciesRoot;
    public float lidAngle;
    public float prevLidAngle;
    private int numPlayersUsing;

    public TileNaturalistChest(ISpeciesRoot speciesRoot) {
        super("naturalist.chest");
        this.speciesRoot = speciesRoot;
        this.setInternalInventory(new InventoryNaturalistChest(this, speciesRoot));
    }

    public void increaseNumPlayersUsing() {
        ++this.numPlayersUsing;
        this.setNeedsNetworkUpdate();
    }

    public void decreaseNumPlayersUsing() {
        --this.numPlayersUsing;
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        this.setNeedsNetworkUpdate();
    }

    @Override
    protected void updateClientSide() {
        this.update();
    }

    @Override
    protected void updateServerSide() {
        this.update();
    }

    private void update() {
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playLidSound("random.chestopen");
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float oldAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            this.lidAngle = Math.max(Math.min(this.lidAngle, 1.0f), 0.0f);
            if (this.lidAngle < 0.5f && oldAngle >= 0.5f) {
                this.playLidSound("random.chestclosed");
            }
        }
    }

    private void playLidSound(String sound) {
        this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, sound, 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void flipPage(EntityPlayer player, short page) {
        GuiHandler.openGui(player, this, page);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeInt(this.numPlayersUsing);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.numPlayersUsing = data.readInt();
    }

    @Override
    public Object getGui(EntityPlayer player, int page) {
        ContainerNaturalistInventory container = new ContainerNaturalistInventory(player.inventory, this, page);
        return new GuiNaturalistInventory(this.speciesRoot, player, container, this, page, 5);
    }

    @Override
    public Object getContainer(EntityPlayer player, int page) {
        return new ContainerNaturalistInventory(player.inventory, this, page);
    }
}

