/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IToolPipette;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.network.packets.PacketPipetteClick;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.ILiquidTankTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class ContainerLiquidTanksHelper<T extends TileEntity>
implements IContainerLiquidTanks {
    private final T tile;

    public ContainerLiquidTanksHelper(T tile) {
        this.tile = tile;
    }

    @Override
    public void handlePipetteClickClient(int slot, EntityPlayer player) {
        ItemStack itemstack = player.inventory.getItemStack();
        if (itemstack == null || !(itemstack.getItem() instanceof IToolPipette)) {
            return;
        }
        Proxies.net.sendToServer(new PacketPipetteClick((TileEntity)this.tile, slot));
    }

    @Override
    public void handlePipetteClick(int slot, EntityPlayerMP player) {
        ItemStack itemstack = player.inventory.getItemStack();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.getItem();
        if (!(held instanceof IToolPipette)) {
            return;
        }
        IToolPipette pipette = (IToolPipette)held;
        IFluidTank tank = ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
        int liquidAmount = tank.getFluidAmount();
        if (pipette.canPipette(itemstack) && liquidAmount > 0) {
            if (liquidAmount > 0) {
                FluidStack fillAmount = tank.drain(1000, false);
                int filled = pipette.fill(itemstack, fillAmount, true);
                tank.drain(filled, true);
                player.updateHeldItem();
            }
        } else {
            FluidStack potential = pipette.drain(itemstack, pipette.getCapacity(itemstack), false);
            if (potential != null) {
                pipette.drain(itemstack, tank.fill(potential, true), true);
                player.updateHeldItem();
            }
        }
    }

    @Override
    public IFluidTank getTank(int slot) {
        return ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
    }
}

