/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.arboriculture.worldgen.ITreeBlockType;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class WorldGenBase
extends WorldGenerator {
    public final boolean generate(World world, Random random, int x, int y, int z) {
        return this.generate(world, x, y, z, false);
    }

    public boolean generate(World world, int x, int y, int z, boolean forced) {
        return false;
    }

    protected abstract boolean addBlock(World var1, int var2, int var3, int var4, ITreeBlockType var5, EnumReplaceMode var6);

    protected final void generateCuboid(World world, Vector start, Vector area, ITreeBlockType block, EnumReplaceMode replace) {
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    this.addBlock(world, x, y, z, block, replace);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCylinder(World world, Vector center, float radius, int height, ITreeBlockType block, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector position = new Vector(x, y, z);
                    Vector treeCenter = new Vector(center.x, y, center.z);
                    if (Vector.distance(position, treeCenter) <= (double)radius + 0.01) {
                        ForgeDirection direction = Vector.direction(position, treeCenter);
                        block.setDirection(direction);
                        this.addBlock(world, x, y, z, block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCircle(World world, Vector center, float radius, int width, int height, ITreeBlockType block, EnumReplaceMode replace) {
        this.generateCircle(world, center, radius, width, height, block, 1.0f, replace);
    }

    protected final void generateCircle(World world, Vector center, float radius, int width, int height, ITreeBlockType block, float chance, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    double distance;
                    if (!(world.rand.nextFloat() > chance) && (double)(radius - (float)width) - 0.01 < (distance = Vector.distance(new Vector(x, y, z), new Vector(center.x, y, center.z))) && distance <= (double)radius + 0.01) {
                        this.addBlock(world, x, y, z, block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateSphere(World world, Vector center, int radius, ITreeBlockType block, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - (float)radius, center.y - (float)radius, center.z - (float)radius);
        Vector area = new Vector(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center.x, center.y, center.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(world, x, y, z, block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static class Vector {
        public final float x;
        public final float y;
        public final float z;

        public Vector(float f, float h, float g) {
            this.x = f;
            this.y = h;
            this.z = g;
        }

        public static double distance(Vector a, Vector b) {
            return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
        }

        public static ForgeDirection direction(Vector a, Vector b) {
            int z;
            int y;
            int x = (int)Math.abs(a.x - b.x);
            int max = Math.max(x, Math.max(y = (int)Math.abs(a.y - b.y), z = (int)Math.abs(a.z - b.z)));
            if (max == x) {
                return ForgeDirection.EAST;
            }
            if (max == z) {
                return ForgeDirection.SOUTH;
            }
            return ForgeDirection.UP;
        }
    }

    protected static enum EnumReplaceMode {
        NONE,
        ALL,
        SOFT;

    }
}

