/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.access.AccessHandler;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.tiles.ILocatable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class MultiblockControllerForestry
extends MultiblockControllerBase
implements ISidedInventory,
IRestrictedAccess,
IErrorLogicSource,
ILocatable {
    private final AccessHandler accessHandler = new AccessHandler(this);
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();

    protected MultiblockControllerForestry(World world) {
        super(world);
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        if (this.worldObj.isRemote) {
            return;
        }
        HashMultiset owners = HashMultiset.create();
        for (IMultiblockComponent part : this.connectedParts) {
            GameProfile owner = part.getOwner();
            if (owner == null) continue;
            owners.add((Object)owner);
        }
        GameProfile owner = null;
        int max = 0;
        for (Multiset.Entry entry : owners.entrySet()) {
            int count = entry.getCount();
            if (count <= max) continue;
            max = count;
            owner = (GameProfile)entry.getElement();
        }
        this.getAccessHandler().setOwner(owner);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        this.accessHandler.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.accessHandler.readFromNBT(data);
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public void markDirty() {
        this.getInternalInventory().markDirty();
    }

    public final int getSizeInventory() {
        return this.getInternalInventory().getSizeInventory();
    }

    public final ItemStack getStackInSlot(int slotIndex) {
        return this.getInternalInventory().getStackInSlot(slotIndex);
    }

    public final ItemStack decrStackSize(int slotIndex, int amount) {
        return this.getInternalInventory().decrStackSize(slotIndex, amount);
    }

    public final ItemStack getStackInSlotOnClosing(int slotIndex) {
        return this.getInternalInventory().getStackInSlotOnClosing(slotIndex);
    }

    public final void setInventorySlotContents(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().setInventorySlotContents(slotIndex, itemstack);
    }

    public final int getInventoryStackLimit() {
        return this.getInternalInventory().getInventoryStackLimit();
    }

    public final void openInventory() {
        this.getInternalInventory().openInventory();
    }

    public final void closeInventory() {
        this.getInternalInventory().closeInventory();
    }

    public final String getInventoryName() {
        return this.getInternalInventory().getInventoryName();
    }

    public final boolean isUseableByPlayer(EntityPlayer player) {
        return this.getInternalInventory().isUseableByPlayer(player);
    }

    public final boolean hasCustomInventoryName() {
        return this.getInternalInventory().hasCustomInventoryName();
    }

    public final boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().isItemValidForSlot(slotIndex, itemStack);
    }

    public final int[] getAccessibleSlotsFromSide(int side) {
        return this.getInternalInventory().getAccessibleSlotsFromSide(side);
    }

    public final boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        return this.getInternalInventory().canInsertItem(slotIndex, itemStack, side);
    }

    public final boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        return this.getInternalInventory().canExtractItem(slotIndex, itemStack, side);
    }
}

