/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeIconProvider;
import forestry.core.render.TextureManager;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public class DefaultBeeIconProvider
implements IBeeIconProvider {
    public static final DefaultBeeIconProvider instance = new DefaultBeeIconProvider();
    private static final IIcon[][] icons = new IIcon[EnumBeeType.values().length][3];

    private DefaultBeeIconProvider() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        String beeIconDir = "bees/default/";
        IIcon body1 = TextureManager.registerTex(register, beeIconDir + "body1");
        for (int i = 0; i < EnumBeeType.values().length; ++i) {
            EnumBeeType beeType = EnumBeeType.values()[i];
            if (beeType == EnumBeeType.NONE) continue;
            String beeTypeNameBase = beeIconDir + beeType.toString().toLowerCase(Locale.ENGLISH);
            DefaultBeeIconProvider.icons[i][0] = TextureManager.registerTex(register, beeTypeNameBase + ".outline");
            DefaultBeeIconProvider.icons[i][1] = beeType == EnumBeeType.LARVAE ? TextureManager.registerTex(register, beeTypeNameBase + ".body") : body1;
            DefaultBeeIconProvider.icons[i][2] = TextureManager.registerTex(register, beeTypeNameBase + ".body2");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(EnumBeeType type, int renderPass) {
        return icons[type.ordinal()][renderPass];
    }
}

