/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.energy.blocks.BlockEngineType;
import forestry.energy.blocks.BlockRegistryEnergy;
import forestry.energy.circuits.CircuitElectricBoost;
import forestry.energy.circuits.CircuitElectricChoke;
import forestry.energy.circuits.CircuitElectricEfficiency;
import forestry.energy.tiles.EngineDefinition;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicRubber;
import forestry.farming.logic.FarmableBasicIC2Crop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginEnergy;
import forestry.plugins.PluginManager;
import ic2.api.crops.ICropTile;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Plugin(pluginID="IC2", name="IndustrialCraft2", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.ic2.description")
public class PluginIC2
extends ForestryPlugin {
    public static PluginIC2 instance;
    private static ItemStack plantBall;
    private static ItemStack compressedPlantBall;
    private static ItemStack wrench;
    private static ItemStack treetap;
    private static ItemStack rubbersapling;
    private static ItemStack rubberleaves;
    private static ItemStack emptyCell;
    private static ItemStack lavaCell;
    private static ItemStack waterCell;
    private static ItemStack rubber;
    private static ItemStack scrap;
    private static ItemStack silver;
    private static ItemStack brass;
    private static ItemStack uuMatter;
    public static ItemStack resin;
    public static ItemStack rubberwood;

    public PluginIC2() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded("IC2");
    }

    @Override
    public String getFailMessage() {
        return "IndustrialCraft2 not found";
    }

    @Override
    public EnumSet<PluginManager.Module> getDependancies() {
        EnumSet<PluginManager.Module> deps = super.getDependancies();
        deps.add(PluginManager.Module.FARMING);
        deps.add(PluginManager.Module.FACTORY);
        return deps;
    }

    @Override
    @Optional.Method(modid="IC2")
    public void preInit() {
        super.preInit();
        BlockRegistryEnergy energyBlocks = PluginEnergy.blocks;
        if (energyBlocks != null) {
            energyBlocks.engine.addDefinitions(new EngineDefinition(BlockEngineType.ELECTRIC), new EngineDefinition(BlockEngineType.GENERATOR));
        }
        if ((emptyCell = IC2Items.getItem((String)"cell")) != null) {
            lavaCell = IC2Items.getItem((String)"lavaCell");
            waterCell = IC2Items.getItem((String)"waterCell");
        } else {
            Log.fine("IC2 empty cell could not be found. Skipped adding IC2 liquid containers.");
        }
        treetap = IC2Items.getItem((String)"treetap");
        rubberwood = IC2Items.getItem((String)"rubberWood");
        resin = IC2Items.getItem((String)"resin");
        rubbersapling = IC2Items.getItem((String)"rubberSapling");
        rubberleaves = IC2Items.getItem((String)"rubberLeaves");
        plantBall = IC2Items.getItem((String)"plantBall");
        compressedPlantBall = IC2Items.getItem((String)"compressedPlantBall");
        resin = IC2Items.getItem((String)"resin");
        rubber = IC2Items.getItem((String)"rubber");
        scrap = IC2Items.getItem((String)"scrap");
        uuMatter = IC2Items.getItem((String)"matter");
        silver = IC2Items.getItem((String)"silverIngot");
        brass = IC2Items.getItem((String)"bronzeIngot");
        Circuit.farmRubberManual = new CircuitFarmLogic("manualRubber", FarmLogicRubber.class);
        CircuitLayout layoutEngineTin = new CircuitLayout("engine.tin", CircuitSocketType.ELECTRIC_ENGINE);
        ChipsetManager.circuitRegistry.registerLayout(layoutEngineTin);
    }

    @Override
    @Optional.Method(modid="IC2")
    public void doInit() {
        super.doInit();
        if (Recipes.recyclerBlacklist != null) {
            if (PluginManager.Module.APICULTURE.isEnabled()) {
                ItemRegistryApiculture beeItems = PluginApiculture.items;
                Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(new ItemStack((Item)beeItems.beeQueenGE)));
                Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(new ItemStack((Item)beeItems.beePrincessGE)));
            }
        } else {
            Log.severe("IC2 Recipes.recyclerBlacklist not found.");
        }
        Circuit.energyElectricChoke1 = new CircuitElectricChoke("electric.choke.1");
        Circuit.energyElectricEfficiency1 = new CircuitElectricEfficiency("electric.efficiency.1");
        Circuit.energyElectricBoost1 = new CircuitElectricBoost("electric.boost.1", 2, 7, 20);
        Circuit.energyElectricBoost2 = new CircuitElectricBoost("electric.boost.2", 2, 15, 40);
    }

    @Override
    @Optional.Method(modid="IC2")
    protected void registerBackpackItems() {
        if (BackpackManager.definitions == null) {
            return;
        }
        IBackpackDefinition forester = BackpackManager.definitions.get("forester");
        if (resin != null) {
            forester.addValidItem(resin);
        }
        if (rubber != null) {
            forester.addValidItem(rubber);
        }
        if (rubbersapling != null) {
            forester.addValidItem(rubbersapling);
        }
        if (rubberleaves != null) {
            forester.addValidItem(rubberleaves);
        }
    }

    @Override
    @Optional.Method(modid="IC2")
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        if (resin != null) {
            crateRegistry.registerCrate(resin, "cratedResin");
        }
        if (rubber != null) {
            crateRegistry.registerCrate(rubber, "cratedRubber");
        }
        if (scrap != null) {
            crateRegistry.registerCrate(scrap, "cratedScrap");
        }
        if (uuMatter != null) {
            crateRegistry.registerCrate(uuMatter, "cratedUUM");
        }
        if (silver != null) {
            crateRegistry.registerCrateUsingOreDict(silver, "cratedSilver");
        }
        if (brass != null) {
            crateRegistry.registerCrateUsingOreDict(brass, "cratedBrass");
        }
    }

    @Override
    @Optional.Method(modid="IC2")
    protected void registerRecipes() {
        BlockRegistryEnergy energyBlocks;
        FluidStack biogas;
        if (rubber != null) {
            for (Object rubberOreDict : RecipeUtil.getOreDictRecipeEquivalents(rubber)) {
                RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), PluginCore.items.tubes.get(EnumElectronTube.RUBBER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), rubberOreDict});
            }
        }
        if (plantBall != null) {
            RecipeUtil.addFermenterRecipes(plantBall, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat") * 9, Fluids.BIOMASS);
        }
        if (compressedPlantBall != null) {
            RecipeUtil.addFermenterRecipes(compressedPlantBall, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat") * 9, Fluids.BIOMASS);
        }
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            if (resin != null) {
                ItemRegistryApiculture beeItems = PluginApiculture.items;
                RecipeManagers.centrifugeManager.addRecipe(20, beeItems.propolis.get(EnumPropolis.NORMAL, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)resin, (Object)Float.valueOf(1.0f)));
            } else {
                Log.fine("Missing IC2 resin, skipping centrifuge recipe for propolis to resin.");
            }
        }
        if (rubbersapling != null) {
            RecipeUtil.addFermenterRecipes(rubbersapling, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        } else {
            Log.fine("Missing IC2 rubber sapling, skipping fermenter recipe for converting rubber sapling to biomass.");
        }
        if (rubbersapling != null && resin != null) {
            String saplingName = GameData.getBlockRegistry().getNameForObject((Object)ItemStackUtil.getBlock(rubbersapling));
            String resinName = GameData.getItemRegistry().getNameForObject((Object)resin.getItem());
            String imc = String.format("farmArboreal@%s.%s.%s.%s", saplingName, rubbersapling.getItemDamage(), resinName, resin.getItemDamage());
            Log.finest("Sending IMC '%s'.", (Object)imc);
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)imc);
        }
        if ((biogas = FluidRegistry.getFluidStack((String)"ic2biogas", (int)1000)) != null && PluginManager.Module.ENERGY.isEnabled()) {
            FuelManager.bronzeEngineFuel.put(biogas.getFluid(), new EngineBronzeFuel(Fluids.BIOMASS.getFluid(), 50, (int)(2500.0f * ForestryAPI.activeMode.getFloatSetting("fuel.biomass.biogas")), 1));
        }
        if (waterCell != null) {
            ItemStack bogEarthCan = ForestryAPI.activeMode.getStackSetting("recipe.output.bogearth.can");
            if (bogEarthCan.stackSize > 0) {
                RecipeUtil.addRecipe(bogEarthCan, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), waterCell, Character.valueOf('Y'), "sand");
            }
        }
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.engine.tin");
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.COPPER, 1), Circuit.energyElectricChoke1);
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.TIN, 1), Circuit.energyElectricBoost1);
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1), Circuit.energyElectricBoost2);
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.IRON, 1), Circuit.energyElectricEfficiency1);
        if (PluginManager.Module.FARMING.isEnabled() && resin != null && rubberwood != null) {
            ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
            ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.RUBBER, 1), Circuit.farmRubberManual);
        }
        Block ic2Crop = GameRegistry.findBlock((String)"IC2", (String)"blockCrop");
        if (PluginManager.Module.FARMING.isEnabled() && ic2Crop != null) {
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicIC2Crop());
        }
        if ((energyBlocks = PluginEnergy.blocks) != null) {
            RecipeUtil.addRecipe(energyBlocks.engine.get(BlockEngineType.GENERATOR), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), PluginCore.items.sturdyCasing});
            RecipeUtil.addRecipe(energyBlocks.engine.get(BlockEngineType.ELECTRIC), "###", " X ", "YVY", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "gearTin", Character.valueOf('V'), Blocks.piston);
        }
    }

    @Optional.Method(modid="IC2")
    public boolean isIC2Crop(TileEntity tileEntity) {
        return tileEntity != null && tileEntity instanceof ICropTile;
    }

    @Optional.Method(modid="IC2")
    public boolean canHarvestCrop(TileEntity tileEntity) {
        if (this.isIC2Crop(tileEntity)) {
            ICropTile crop = (ICropTile)tileEntity;
            if (crop.getCrop() == null) {
                return false;
            }
            if (crop.getSize() == crop.getCrop().getOptimalHavestSize(crop)) {
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    public void babysitCrop(TileEntity tileEntity) {
        if (this.isIC2Crop(tileEntity)) {
            ICropTile crop = (ICropTile)tileEntity;
            if (crop.getHydrationStorage() <= 200) {
                crop.setHydrationStorage(200);
            }
            if (crop.getNutrientStorage() <= 100) {
                crop.setNutrientStorage(crop.getNutrientStorage() + 100);
            }
        }
    }

    @Optional.Method(modid="IC2")
    public ArrayList<ItemStack> getCropDrops(TileEntity tileEntity) {
        ICropTile crop;
        ItemStack[] cropDrops;
        if (this.isIC2Crop(tileEntity) && (cropDrops = (crop = (ICropTile)tileEntity).harvest_automated(true)) != null) {
            return new ArrayList<ItemStack>(Arrays.asList(cropDrops));
        }
        return null;
    }
}

