/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.core.fluids.FluidHelper;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.SlotUtil;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.tiles.TileCarpenter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class InventoryCarpenter
extends InventoryAdapterTile<TileCarpenter> {
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_PRODUCT_COUNT = 1;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;

    public InventoryCarpenter(TileCarpenter carpenter) {
        super(carpenter, 30, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 11) {
            Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
            return ((TileCarpenter)this.tile).getTankManager().accepts(fluid);
        }
        if (slotIndex == 9) {
            return CarpenterRecipeManager.isBox(itemStack);
        }
        if (this.canSlotAccept(11, itemStack) || this.canSlotAccept(9, itemStack)) {
            return false;
        }
        return SlotUtil.isSlotInRange(slotIndex, 12, 18);
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
        return slotIndex == 10;
    }
}

