/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.ForestryAPI;
import forestry.core.gui.GuiId;
import forestry.core.gui.GuiIdRegistry;
import forestry.core.gui.IGuiHandlerEntity;
import forestry.core.gui.IGuiHandlerForestry;
import forestry.core.gui.IGuiHandlerItem;
import forestry.core.gui.IGuiHandlerTile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class GuiHandler
implements IGuiHandler {
    public static void openGui(EntityPlayer entityplayer, IGuiHandlerEntity guiHandler) {
        GuiHandler.openGui(entityplayer, guiHandler, (short)0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerEntity guiHandler, short data) {
        int guiData = GuiHandler.encodeGuiData(guiHandler, data);
        entityplayer.openGui(ForestryAPI.instance, guiData, entityplayer.worldObj, guiHandler.getIdOfEntity(), 0, 0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerItem guiHandler) {
        GuiHandler.openGui(entityplayer, guiHandler, (short)0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerItem guiHandler, short data) {
        int guiData = GuiHandler.encodeGuiData(guiHandler, data);
        entityplayer.openGui(ForestryAPI.instance, guiData, entityplayer.worldObj, 0, 0, 0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerTile guiHandler) {
        GuiHandler.openGui(entityplayer, guiHandler, (short)0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerTile guiHandler, short data) {
        int guiData = GuiHandler.encodeGuiData(guiHandler, data);
        ChunkCoordinates coordinates = guiHandler.getCoordinates();
        entityplayer.openGui(ForestryAPI.instance, guiData, entityplayer.worldObj, coordinates.posX, coordinates.posY, coordinates.posZ);
    }

    private static int encodeGuiData(IGuiHandlerForestry guiHandler, short data) {
        GuiId guiId = GuiIdRegistry.getGuiIdForGuiHandler(guiHandler);
        return data << 16 | guiId.getId();
    }

    private static GuiId decodeGuiID(int guiData) {
        int guiId = guiData & 0xFF;
        return GuiIdRegistry.getGuiId(guiId);
    }

    private static short decodeGuiData(int guiId) {
        return (short)(guiId >> 16);
    }

    public Object getClientGuiElement(int guiData, EntityPlayer player, World world, int x, int y, int z) {
        GuiId guiId = GuiHandler.decodeGuiID(guiData);
        if (guiId == null) {
            return null;
        }
        short data = GuiHandler.decodeGuiData(guiData);
        switch (guiId.getGuiType()) {
            case Item: {
                ItemStack heldItem = player.getCurrentEquippedItem();
                if (heldItem == null) break;
                Item item = heldItem.getItem();
                if (!guiId.getGuiHandlerClass().isInstance(item)) break;
                return ((IGuiHandlerItem)item).getGui(player, heldItem, data);
            }
            case Tile: {
                TileEntity tileEntity = world.getTileEntity(x, y, z);
                if (!guiId.getGuiHandlerClass().isInstance(tileEntity)) break;
                return ((IGuiHandlerTile)tileEntity).getGui(player, data);
            }
            case Entity: {
                Entity entity = world.getEntityByID(x);
                if (!guiId.getGuiHandlerClass().isInstance(entity)) break;
                return ((IGuiHandlerEntity)entity).getGui(player, data);
            }
        }
        return null;
    }

    public Object getServerGuiElement(int guiData, EntityPlayer player, World world, int x, int y, int z) {
        GuiId guiId = GuiHandler.decodeGuiID(guiData);
        if (guiId == null) {
            return null;
        }
        short data = GuiHandler.decodeGuiData(guiData);
        switch (guiId.getGuiType()) {
            case Item: {
                ItemStack heldItem = player.getCurrentEquippedItem();
                if (heldItem == null) break;
                Item item = heldItem.getItem();
                if (!guiId.getGuiHandlerClass().isInstance(item)) break;
                return ((IGuiHandlerItem)item).getContainer(player, heldItem, data);
            }
            case Tile: {
                TileEntity tileEntity = world.getTileEntity(x, y, z);
                if (!guiId.getGuiHandlerClass().isInstance(tileEntity)) break;
                return ((IGuiHandlerTile)tileEntity).getContainer(player, data);
            }
            case Entity: {
                Entity entity = world.getEntityByID(x);
                if (!guiId.getGuiHandlerClass().isInstance(entity)) break;
                return ((IGuiHandlerEntity)entity).getContainer(player, data);
            }
        }
        return null;
    }
}

