/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.vect.Vect;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class AlleleEffectRadioactive
extends AlleleEffectThrottled {
    private static final DamageSource damageSourceBeeRadioactive = new DamageSourceForestry("bee.radioactive");

    public AlleleEffectRadioactive() {
        super("radioactive", true, 40, false, true);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.harmEntities(genome, housing);
        return AlleleEffectRadioactive.destroyEnvironment(genome, storedData, housing);
    }

    private void harmEntities(IBeeGenome genome, IBeeHousing housing) {
        List<EntityLivingBase> entities = AlleleEffectRadioactive.getEntitiesInRange(genome, housing, EntityLivingBase.class);
        for (EntityLivingBase entity : entities) {
            int damage = 8;
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getUID(), true);
            if ((damage -= count) <= 0) continue;
            entity.attackEntityFrom(damageSourceBeeRadioactive, (float)damage);
        }
    }

    private static IEffectData destroyEnvironment(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        Random rand = world.rand;
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr).multiply(2);
        Vect offset = area.multiply(-0.5f);
        Vect posHousing = new Vect(housing.getCoordinates());
        for (int i = 0; i < 20; ++i) {
            TileEntity tile;
            Block block;
            Vect randomPos = Vect.getRandomPositionInArea(rand, area);
            Vect posBlock = randomPos.add(posHousing);
            posBlock = posBlock.add(offset);
            if (posBlock.y <= 1 || posBlock.y >= housing.getWorld().getActualHeight() || posBlock.x == posHousing.x && posBlock.z == posHousing.z && posBlock.y <= posHousing.y || world.isAirBlock(posBlock.x, posBlock.y, posBlock.z) || (block = world.getBlock(posBlock.x, posBlock.y, posBlock.z)) instanceof BlockAlveary || (tile = world.getTileEntity(posBlock.x, posBlock.y, posBlock.z)) instanceof IBeeHousing || block.getBlockHardness(world, posBlock.x, posBlock.y, posBlock.z) < 0.0f) continue;
            world.setBlockToAir(posBlock.x, posBlock.y, posBlock.z);
            break;
        }
        return storedData;
    }
}

