/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.apiculture.worldgen.HiveGen;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HiveGenGround
extends HiveGen {
    private final Set<Material> groundMaterials = new HashSet<Material>();

    public HiveGenGround(Block ... groundBlocks) {
        for (Block block : groundBlocks) {
            this.groundMaterials.add(block.getMaterial());
        }
    }

    @Override
    public boolean isValidLocation(World world, int x, int y, int z) {
        Block ground = world.getBlock(x, y - 1, z);
        return this.groundMaterials.contains(ground.getMaterial());
    }

    @Override
    public int getYForHive(World world, int x, int z) {
        int y;
        for (y = world.getHeightValue(x, z); y >= 0 && (world.getBlock(x, y - 1, z).isLeaves((IBlockAccess)world, x, y - 1, z) || this.canReplace(world, x, y - 1, z)); --y) {
        }
        return y;
    }
}

