/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class ModelButterfly
extends ModelBase {
    private final ModelRenderer wingRight;
    private final ModelRenderer eyeRight;
    private final ModelRenderer eyeLeft;
    private final ModelRenderer wingLeft;
    private final ModelRenderer body;
    private float scale;

    public ModelButterfly() {
        this.textureWidth = 64;
        this.textureHeight = 32;
        this.wingRight = new ModelRenderer((ModelBase)this, 0, 0);
        this.wingRight.addBox(-7.0f, 0.0f, -6.0f, 7, 1, 13);
        this.wingRight.setRotationPoint(-0.5f, 0.5f, 0.0f);
        this.wingRight.setTextureSize(64, 32);
        this.wingRight.mirror = true;
        ModelButterfly.setRotation(this.wingRight, 0.0f, 0.0f, 0.0f);
        this.eyeRight = new ModelRenderer((ModelBase)this, 40, 9);
        this.eyeRight.addBox(0.0f, 0.0f, 0.0f, 1, 1, 1);
        this.eyeRight.setRotationPoint(-1.1f, -0.5f, -4.5f);
        this.eyeRight.setTextureSize(64, 32);
        this.eyeRight.mirror = true;
        ModelButterfly.setRotation(this.eyeRight, 0.0f, 0.0f, 0.0f);
        this.eyeLeft = new ModelRenderer((ModelBase)this, 40, 7);
        this.eyeLeft.addBox(0.0f, 0.0f, 0.0f, 1, 1, 1);
        this.eyeLeft.setRotationPoint(0.1f, -0.5f, -4.5f);
        this.eyeLeft.setTextureSize(64, 32);
        this.eyeLeft.mirror = true;
        ModelButterfly.setRotation(this.eyeLeft, 0.0f, 0.0f, 0.0f);
        this.wingLeft = new ModelRenderer((ModelBase)this, 0, 14);
        this.wingLeft.addBox(0.0f, 0.0f, -6.0f, 7, 1, 13);
        this.wingLeft.setRotationPoint(0.5f, 0.5f, 0.0f);
        this.wingLeft.setTextureSize(64, 32);
        this.wingLeft.mirror = true;
        ModelButterfly.setRotation(this.wingLeft, 0.0f, 0.0f, 0.0f);
        this.body = new ModelRenderer((ModelBase)this, 40, 0);
        this.body.addBox(0.0f, 0.0f, -4.0f, 1, 1, 6);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.body.setTextureSize(64, 32);
        this.body.mirror = true;
        ModelButterfly.setRotation(this.body, 0.0f, 0.0f, 0.7853982f);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void render(Entity entity, float f, float f1, float swing, float f3, float f4, float f5) {
        super.render(entity, f, f1, swing, f3, f4, f5);
        this.wingRight.rotateAngleZ = MathHelper.cos((float)(swing * 1.3f)) * (float)Math.PI * 0.25f;
        this.wingLeft.rotateAngleZ = -this.wingRight.rotateAngleZ;
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        GL11.glTranslatef((float)0.0f, (float)(20.0f / this.scale * f5), (float)0.0f);
        this.wingRight.render(f5);
        this.eyeRight.render(f5);
        this.eyeLeft.render(f5);
        this.wingLeft.render(f5);
        this.body.render(f5);
        GL11.glPopMatrix();
    }

    private static void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float swing, float f3, float f4, float f5, Entity entity) {
        super.setRotationAngles(f, f1, swing, f3, f4, f5, entity);
    }
}

