/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.inventory;

import forestry.api.arboriculture.TreeManager;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.utils.GeneticsUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemInventoryTreealyzer
extends ItemInventoryAlyzer
implements IHintSource {
    public ItemInventoryTreealyzer(EntityPlayer player, ItemStack itemStack) {
        super(TreeManager.treeRoot, player, itemStack);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        ItemStack ersatz;
        if (!TreeManager.treeRoot.isMember(itemStack) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(itemStack)) != null) {
            return super.canSlotAccept(slotIndex, ersatz);
        }
        return super.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public void onSlotClick(EntityPlayer player) {
        ItemStack ersatz;
        ItemStack specimen = this.getStackInSlot(0);
        if (!TreeManager.treeRoot.isMember(specimen) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(specimen)) != null) {
            this.setInventorySlotContents(0, ersatz);
        }
        super.onSlotClick(player);
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"treealyzer");
    }
}

