/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IMutation;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.core.config.Config;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class Tree
extends Individual
implements ITree,
IPlantable {
    private ITreeGenome genome;
    private ITreeGenome mate;
    private EnumSet<EnumPlantType> plantTypes;
    private EnumPlantType plantType;

    public Tree(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Tree(ITreeGenome genome) {
        this.setGenome(genome);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("Genome")) {
            this.setGenome(new TreeGenome(nbttagcompound.getCompoundTag("Genome")));
        } else {
            this.setGenome(TreeDefinition.Oak.getGenome());
        }
        if (nbttagcompound.hasKey("Mate")) {
            this.mate = new TreeGenome(nbttagcompound.getCompoundTag("Mate"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.genome != null) {
            NBTTagCompound nbtGenome = new NBTTagCompound();
            this.genome.writeToNBT(nbtGenome);
            nbttagcompound.setTag("Genome", (NBTBase)nbtGenome);
        }
        if (this.mate != null) {
            NBTTagCompound nbtMate = new NBTTagCompound();
            this.mate.writeToNBT(nbtMate);
            nbttagcompound.setTag("Mate", (NBTBase)nbtMate);
        }
    }

    @Override
    public void mate(ITree other) {
        this.mate = new TreeGenome(other.getGenome().getChromosomes());
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, World world, int x, int y, int z) {
        IAlleleLeafEffect effect = (IAlleleLeafEffect)this.getGenome().getActiveAllele(EnumTreeChromosome.EFFECT);
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], world, x, y, z);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleLeafEffect secondary = (IAlleleLeafEffect)this.getGenome().getInactiveAllele(EnumTreeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], world, x, y, z);
        return storedData;
    }

    private IEffectData doEffect(IAlleleLeafEffect effect, IEffectData storedData, World world, int x, int y, int z) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.getGenome(), storedData, world, x, y, z);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public WorldGenerator getTreeGenerator(World world, int x, int y, int z, boolean wasBonemealed) {
        return this.genome.getPrimary().getGenerator().getWorldGenerator(this);
    }

    @Override
    public boolean canStay(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y - 1, z);
        if (block == null) {
            return false;
        }
        Iterator iterator = this.getPlantTypes().iterator();
        while (iterator.hasNext()) {
            EnumPlantType type;
            this.plantType = type = (EnumPlantType)iterator.next();
            if (!block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this)) continue;
            return true;
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return this.plantType;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return null;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    @Override
    public boolean canGrow(World world, int x, int y, int z, int expectedGirth, int expectedHeight) {
        IGrowthProvider growthProvider = this.genome.getGrowthProvider();
        return growthProvider.canGrow(this.genome, world, x, y, z, expectedGirth, expectedHeight);
    }

    @Override
    public int getRequiredMaturity() {
        return this.genome.getMaturationTime();
    }

    @Override
    public EnumGrowthConditions getGrowthCondition(World world, int x, int y, int z) {
        return this.genome.getGrowthProvider().getGrowthConditions(this.getGenome(), world, x, y, z);
    }

    @Override
    public int getGirth(World world, int x, int y, int z) {
        return this.genome.getGirth();
    }

    @Override
    public int getResilience() {
        int base = (int)(this.getGenome().getFertility() * this.getGenome().getSappiness() * 100.0f);
        return (base > 1 ? base : 1) * 10;
    }

    @Override
    public float getHeightModifier() {
        return this.genome.getHeight();
    }

    @Override
    public void setLeaves(World world, GameProfile owner, int x, int y, int z) {
        try {
            this.genome.getPrimary().getGenerator().setLeaves(this.genome, world, owner, x, y, z, false);
        }
        catch (Throwable ignored) {
            this.genome.getPrimary().getGenerator().setLeaves(world, owner, x, y, z, false);
        }
    }

    @Override
    public void setLeavesDecorative(World world, GameProfile owner, int x, int y, int z) {
        try {
            this.genome.getPrimary().getGenerator().setLeaves(this.genome, world, owner, x, y, z, true);
        }
        catch (Throwable ignored) {
            this.genome.getPrimary().getGenerator().setLeaves(world, owner, x, y, z, true);
        }
    }

    @Override
    public void setLogBlock(World world, int x, int y, int z, ForgeDirection facing) {
        try {
            this.genome.getPrimary().getGenerator().setLogBlock(this.genome, world, x, y, z, facing);
        }
        catch (Throwable ignored) {
            this.genome.getPrimary().getGenerator().setLogBlock(world, x, y, z, facing);
        }
    }

    @Override
    public boolean allowsFruitBlocks() {
        IFruitProvider provider = this.getGenome().getFruitProvider();
        if (!provider.requiresFruitBlocks()) {
            return false;
        }
        Collection<IFruitFamily> suitable = this.genome.getPrimary().getSuitableFruit();
        return suitable.contains(provider.getFamily());
    }

    @Override
    public boolean trySpawnFruitBlock(World world, int x, int y, int z) {
        IFruitProvider provider = this.getGenome().getFruitProvider();
        Collection<IFruitFamily> suitable = this.genome.getPrimary().getSuitableFruit();
        if (!suitable.contains(provider.getFamily())) {
            return false;
        }
        return provider.trySpawnFruitBlock(this.getGenome(), world, x, y, z);
    }

    @Override
    public ITreeGenome getGenome() {
        return this.genome;
    }

    private void setGenome(ITreeGenome genome) {
        this.genome = genome;
        this.plantTypes = genome.getPlantTypes();
        this.plantTypes.add(genome.getPrimary().getPlantType());
    }

    @Override
    public ITree copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Tree(nbttagcompound);
    }

    @Override
    public ITreeGenome getMate() {
        return this.mate;
    }

    @Override
    public boolean isPureBred(EnumTreeChromosome chromosome) {
        return this.genome.getActiveAllele(chromosome).getUID().equals(this.genome.getInactiveAllele(chromosome).getUID());
    }

    @Override
    public EnumSet<EnumPlantType> getPlantTypes() {
        return this.plantTypes;
    }

    @Override
    public void addTooltip(List<String> list) {
        IAllele fruit;
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleTreeSpecies primary = this.genome.getPrimary();
        IAlleleTreeSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumTreeChromosome.SPECIES)) {
            list.add(EnumChatFormatting.BLUE + StringUtil.localize("trees.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        String sappiness = EnumChatFormatting.GOLD + "S: " + this.genome.getActiveAllele(EnumTreeChromosome.SAPPINESS).getName();
        String maturation = EnumChatFormatting.RED + "M: " + this.genome.getActiveAllele(EnumTreeChromosome.MATURATION).getName();
        String height = EnumChatFormatting.LIGHT_PURPLE + "H: " + this.genome.getActiveAllele(EnumTreeChromosome.HEIGHT).getName();
        String girth = EnumChatFormatting.AQUA + "G: " + String.format("%sx%s", this.genome.getGirth(), this.genome.getGirth());
        String saplings = EnumChatFormatting.YELLOW + "S: " + this.genome.getActiveAllele(EnumTreeChromosome.FERTILITY).getName();
        String yield = EnumChatFormatting.WHITE + "Y: " + this.genome.getActiveAllele(EnumTreeChromosome.YIELD).getName();
        list.add(String.format("%s, %s", saplings, maturation));
        list.add(String.format("%s, %s", height, girth));
        list.add(String.format("%s, %s", yield, sappiness));
        IAlleleBoolean primaryFireproof = (IAlleleBoolean)this.genome.getActiveAllele(EnumTreeChromosome.FIREPROOF);
        if (primaryFireproof.getValue()) {
            list.add(EnumChatFormatting.RED + StatCollector.translateToLocal((String)"for.gui.fireresist"));
        }
        if ((fruit = this.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS)) != AlleleFruit.fruitNone) {
            String strike = "";
            if (!this.canBearFruit()) {
                strike = EnumChatFormatting.STRIKETHROUGH.toString();
            }
            list.add(strike + EnumChatFormatting.GREEN + "F: " + StringUtil.localize(this.genome.getFruitProvider().getDescription()));
        }
    }

    @Override
    public ITree[] getSaplings(World world, GameProfile playerProfile, int x, int y, int z, float modifier) {
        ArrayList<ITree> prod = new ArrayList<ITree>();
        float chance = this.genome.getFertility() * modifier;
        if (world.rand.nextFloat() <= chance) {
            if (this.getMate() == null) {
                prod.add(TreeManager.treeRoot.getTree(world, new TreeGenome(this.genome.getChromosomes())));
            } else {
                prod.add(this.createOffspring(world, playerProfile, x, y, z));
            }
        }
        return prod.toArray(new ITree[prod.size()]);
    }

    private ITree createOffspring(World world, GameProfile playerProfile, int x, int y, int z) {
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated = Tree.mutateSpecies(world, playerProfile, x, y, z, this.genome, this.mate);
        if (mutated == null) {
            mutated = Tree.mutateSpecies(world, playerProfile, x, y, z, this.mate, this.genome);
        }
        if (mutated != null) {
            return new Tree(new TreeGenome(mutated));
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.rand, parent1[i], parent2[i]);
        }
        return new Tree(new TreeGenome(chromosomes));
    }

    private static IChromosome[] mutateSpecies(World world, @Nullable GameProfile playerProfile, int x, int y, int z, ITreeGenome genomeOne, ITreeGenome genomeTwo) {
        ITreeGenome genome1;
        ITreeGenome genome0;
        IAlleleTreeSpecies allele1;
        IAlleleTreeSpecies allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.rand.nextBoolean()) {
            allele0 = (IAlleleTreeSpecies)parent1[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = (IAlleleTreeSpecies)parent2[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = (IAlleleTreeSpecies)parent2[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = (IAlleleTreeSpecies)parent1[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        IArboristTracker breedingTracker = null;
        if (playerProfile != null) {
            breedingTracker = TreeManager.treeRoot.getBreedingTracker(world, playerProfile);
        }
        List<IMutation> combinations = TreeManager.treeRoot.getCombinations(allele0, allele1, true);
        for (IMutation mutation : combinations) {
            ITreeMutation treeMutation = (ITreeMutation)mutation;
            float chance = treeMutation.getChance(world, x, y, z, allele0, allele1, genome0, genome1);
            if (chance <= 0.0f) continue;
            if (breedingTracker != null && breedingTracker.isResearched(treeMutation)) {
                float mutationBoost = chance * (Config.researchMutationBoostMultiplier - 1.0f);
                mutationBoost = Math.min(Config.maxResearchMutationBoostPercent, mutationBoost);
                chance += mutationBoost;
            }
            if (!(chance > world.rand.nextFloat() * 100.0f)) continue;
            return TreeManager.treeRoot.templateAsChromosomes(treeMutation.getTemplate());
        }
        return null;
    }

    @Override
    public boolean canBearFruit() {
        return this.genome.getPrimary().getSuitableFruit().contains(this.genome.getFruitProvider().getFamily());
    }

    @Override
    public ItemStack[] getProduceList() {
        return this.genome.getFruitProvider().getProducts();
    }

    @Override
    public ItemStack[] getSpecialtyList() {
        return this.genome.getFruitProvider().getSpecialty();
    }

    @Override
    public ItemStack[] produceStacks(World world, int x, int y, int z, int ripeningTime) {
        return this.genome.getFruitProvider().getFruits(this.genome, world, x, y, z, ripeningTime);
    }
}

