/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MutationConditionRequiresResource
implements IMutationCondition {
    private final ItemStack blockRequired;

    public MutationConditionRequiresResource(Block block, int meta) {
        this.blockRequired = new ItemStack(block, 1, meta);
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        int meta;
        Block block;
        TileEntity tile;
        int i = 1;
        do {
            block = world.getBlock(x, y - i, z);
            meta = world.getBlockMetadata(x, y - i, z);
            tile = world.getTileEntity(x, y - i, z);
            ++i;
        } while (tile instanceof IBeeHousing);
        return ItemStackUtil.equals(block, meta, this.blockRequired) ? 1.0f : 0.0f;
    }

    @Override
    public String getDescription() {
        return StringUtil.localizeAndFormat("mutation.condition.resource", this.blockRequired.getDisplayName());
    }
}

