/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.fluids.BlockForestryFluid;
import forestry.core.fluids.FluidHelper;
import forestry.core.items.EnumContainerType;
import forestry.core.items.ItemLiquidContainer;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.text.WordUtils;

public enum Fluids {
    ETHANOL(new Color(255, 111, 0), 790, 1000){

        @Override
        public String getTag() {
            return "bioethanol";
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 300, true);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET, EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    BIOMASS(new Color(100, 132, 41), 400, 6560){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 100, true);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET, EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    GLASS(new Color(164, 164, 164), 2400, 10000){

        @Override
        public int getTemperature() {
            return 1200;
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 0, true);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET);
        }
    }
    ,
    HONEY(new Color(255, 196, 35), 1420, 73600){

        @Override
        public String getTag() {
            return "for.honey";
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET, EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }

        @Override
        public void setProperties(ItemLiquidContainer liquidContainer) {
            if (liquidContainer.getType() != EnumContainerType.BUCKET) {
                liquidContainer.setDrink(2, 0.2f);
            }
        }
    }
    ,
    LEGACY_HONEY(new Color(255, 196, 35)){

        @Override
        public String getTag() {
            return "honey";
        }
    }
    ,
    ICE(new Color(175, 242, 255), 920, 1000){

        @Override
        public int getTemperature() {
            return 265;
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET, EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    JUICE(new Color(168, 201, 114)){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET, EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }

        @Override
        public void setProperties(ItemLiquidContainer liquidContainer) {
            if (liquidContainer.getType() != EnumContainerType.BUCKET) {
                liquidContainer.setDrink(2, 0.2f);
            }
        }
    }
    ,
    MILK(new Color(255, 255, 255), 1030, 3000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public List<ItemStack> getOtherContainers() {
            return Collections.singletonList(new ItemStack(Items.milk_bucket));
        }
    }
    ,
    SEEDOIL("SeedOil", new Color(255, 255, 168), 885, 5000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 2, true);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET, EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    SHORT_MEAD("ShortMead", new Color(239, 154, 56), 1000, 1200){

        @Override
        public String getTag() {
            return "short.mead";
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET, EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    MEAD("Mead", new Color(202, 102, 0), 1000, 1200){

        @Override
        public String getTag() {
            return "mead";
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.BUCKET, EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    WATER(new Color(2372332)){

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    LAVA(new Color(16598559)){

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.REFRACTORY);
        }
    }
    ,
    FUEL(new Color(0xFFFF00)){

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    OIL(new Color(0x404040)){

        @Override
        public EnumSet<EnumContainerType> getContainerTypes() {
            return EnumSet.of(EnumContainerType.CAN, EnumContainerType.CAPSULE, EnumContainerType.REFRACTORY);
        }
    }
    ,
    CREOSOTE(new Color(6511619)),
    STEAM(new Color(9540495));

    public static final Fluids[] forestryFluids;
    private static final Map<String, Fluids> tagToFluid;
    private final String containerNameKey;
    private final String tag;
    private final int density;
    private final int viscosity;
    @Nonnull
    private final Color color;

    private Fluids(Color color) {
        this(null, color, 1000, 1000);
    }

    private Fluids(Color color, int density, int viscosity) {
        this(null, color, density, viscosity);
    }

    private Fluids(String containerNameKey, Color color, int density, int viscosity) {
        if (containerNameKey == null) {
            containerNameKey = WordUtils.capitalize((String)this.toString().toLowerCase(Locale.ENGLISH));
        }
        this.containerNameKey = containerNameKey;
        this.tag = this.name().toLowerCase(Locale.ENGLISH);
        this.color = color;
        this.density = density;
        this.viscosity = viscosity;
    }

    public int getTemperature() {
        return 295;
    }

    public String getTag() {
        return this.tag;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.getTag());
    }

    public final FluidStack getFluid(int mb) {
        return FluidRegistry.getFluidStack((String)this.getTag(), (int)mb);
    }

    public final Block getBlock() {
        Fluid fluid = this.getFluid();
        if (fluid == null) {
            return null;
        }
        return fluid.getBlock();
    }

    @Nonnull
    public final Color getColor() {
        return this.color;
    }

    public final boolean is(Fluid fluid) {
        return this.getFluid() == fluid;
    }

    public final boolean is(FluidStack fluidStack) {
        return fluidStack != null && this.getFluid() == fluidStack.getFluid();
    }

    public final boolean isContained(ItemStack containerStack) {
        return containerStack != null && FluidHelper.containsFluid(containerStack, this.getFluid());
    }

    public static boolean areEqual(Fluid fluid, FluidStack fluidStack) {
        if (fluidStack != null && fluid == fluidStack.getFluid()) {
            return true;
        }
        return fluid == null && fluidStack == null;
    }

    public static boolean areEqual(FluidStack a, FluidStack b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.isFluidEqual(b);
    }

    @Nonnull
    public static Color getFluidColor(FluidStack fluidStack) {
        Fluids fluids;
        Fluid fluid;
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null && (fluids = tagToFluid.get(fluid.getName())) != null) {
            return fluids.getColor();
        }
        return WATER.getColor();
    }

    public String getContainerNameKey() {
        return this.containerNameKey;
    }

    public EnumSet<EnumContainerType> getContainerTypes() {
        return EnumSet.noneOf(EnumContainerType.class);
    }

    public List<ItemStack> getOtherContainers() {
        return Collections.emptyList();
    }

    public Block makeBlock() {
        return null;
    }

    public void setProperties(ItemLiquidContainer liquidContainer) {
    }

    static {
        forestryFluids = new Fluids[]{ETHANOL, BIOMASS, GLASS, HONEY, LEGACY_HONEY, ICE, JUICE, MILK, SEEDOIL, SHORT_MEAD, MEAD};
        tagToFluid = new HashMap<String, Fluids>();
        for (Fluids fluids : Fluids.values()) {
            tagToFluid.put(fluids.getTag(), fluids);
        }
    }
}

